/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.security.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.tfeng.play.plugins.OAuth2Plugin;
import me.tfeng.play.security.oauth2.OAuth2Authentication;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.stereotype.Service;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.Json;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Result;

@Service
@OAuth2Authentication
@BodyParser.Of(value=BodyParser.Json.class)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2AuthenticationController
extends Controller {
    public F.Promise<Result> authenticateClient() {
        JsonNode json = OAuth2AuthenticationController.request().body().asJson();
        String clientId = json.findPath("clientId").textValue();
        String clientSecret = json.findPath("clientSecret").textValue();
        OAuth2Plugin oauth2Plugin = OAuth2Plugin.getInstance();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)clientId, (Object)clientSecret);
        oauth2Plugin.getClientAuthenticationManager().authenticate((Authentication)authRequest);
        ClientDetails clientDetails = oauth2Plugin.getClientDetailsService().loadClientByClientId(clientId);
        TokenRequest tokenRequest = new TokenRequest(Collections.emptyMap(), clientId, (Collection)clientDetails.getScope(), "password");
        OAuth2AccessToken token = oauth2Plugin.getTokenGranter().grant("client_credentials", tokenRequest);
        ObjectNode result = Json.newObject();
        result.setAll((Map)ImmutableMap.of((Object)"accessToken", (Object)result.textNode(token.getValue()), (Object)"clientId", (Object)result.textNode(clientId), (Object)"expiration", (Object)result.numberNode(token.getExpiration().getTime())));
        return F.Promise.pure((Object)OAuth2AuthenticationController.ok((JsonNode)result));
    }

    @PreAuthorize(value="#oauth2.clientHasRole('ROLE_CLIENT') and #oauth2.hasScope('trust')")
    public F.Promise<Result> authenticateUser() {
        JsonNode json = OAuth2AuthenticationController.request().body().asJson();
        String username = json.findPath("username").textValue();
        String password = json.findPath("password").textValue();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        OAuth2Request clientAuthenticationRequest = ((org.springframework.security.oauth2.provider.OAuth2Authentication)authentication).getOAuth2Request();
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("username", username);
        requestParameters.put("password", password);
        TokenRequest tokenRequest = new TokenRequest(requestParameters, clientAuthenticationRequest.getClientId(), (Collection)clientAuthenticationRequest.getScope(), "password");
        OAuth2AccessToken token = OAuth2Plugin.getInstance().getTokenGranter().grant("password", tokenRequest);
        ObjectNode result = Json.newObject();
        result.setAll((Map)ImmutableMap.of((Object)"accessToken", (Object)result.textNode(token.getValue()), (Object)"username", (Object)result.textNode(username), (Object)"expiration", (Object)result.numberNode(token.getExpiration().getTime()), (Object)"refreshToken", (Object)result.textNode(token.getRefreshToken().getValue())));
        return F.Promise.pure((Object)OAuth2AuthenticationController.ok((JsonNode)result));
    }

    @PreAuthorize(value="#oauth2.clientHasRole('ROLE_CLIENT') and #oauth2.hasScope('trust')")
    public F.Promise<Result> refreshUserAccessToken() {
        JsonNode body = OAuth2AuthenticationController.request().body().asJson();
        String refreshToken = body.findPath("refreshToken").textValue();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        OAuth2Request clientAuthenticationRequest = ((org.springframework.security.oauth2.provider.OAuth2Authentication)authentication).getOAuth2Request();
        TokenRequest tokenRequest = new TokenRequest(Collections.emptyMap(), clientAuthenticationRequest.getClientId(), (Collection)clientAuthenticationRequest.getScope(), "refresh");
        OAuth2AccessToken token = OAuth2Plugin.getInstance().getTokenServices().refreshAccessToken(refreshToken, tokenRequest);
        ObjectNode result = Json.newObject();
        result.setAll((Map)ImmutableMap.of((Object)"accessToken", (Object)result.textNode(token.getValue()), (Object)"expiration", (Object)result.numberNode(token.getExpiration().getTime()), (Object)"refreshToken", (Object)result.textNode(token.getRefreshToken().getValue())));
        return F.Promise.pure((Object)OAuth2AuthenticationController.ok((JsonNode)result));
    }
}

