/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.security.oauth2;

import me.tfeng.play.plugins.OAuth2Plugin;
import me.tfeng.play.security.oauth2.OAuth2Authentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2AuthenticationAction
extends Action<OAuth2Authentication> {
    private static final Logger.ALogger LOG = Logger.of(OAuth2AuthenticationAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public F.Promise<Result> call(Http.Context context) throws Throwable {
        Http.Request request = context.request();
        String token = this.getAuthorizationToken(request);
        if (token == null) {
            token = request.getQueryString("access_token");
        }
        if (token == null) {
            LOG.info("Authentication skipped");
        } else {
            PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken((Object)token, (Object)"");
            Authentication authResult = OAuth2Plugin.getInstance().getOAuth2AuthenticationManager().authenticate((Authentication)authRequest);
            SecurityContextHolder.getContext().setAuthentication(authResult);
            LOG.info("Authenticated successfully");
        }
        try {
            F.Promise promise = this.delegate.call(context);
            return promise;
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    protected String getAuthorizationToken(Http.Request request) {
        String[] headers = (String[])request.headers().get("Authorization");
        if (headers != null) {
            for (String header : headers) {
                if (!header.toLowerCase().startsWith("Bearer".toLowerCase())) continue;
                String authHeaderValue = header.substring("Bearer".length()).trim();
                return authHeaderValue.split(",")[0];
            }
        }
        return null;
    }
}

