/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import me.tfeng.play.plugins.AbstractPlugin;
import me.tfeng.play.spring.WithSpringConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import play.Application;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@WithSpringConfig(value={"classpath:oauth2-plugin.xml"})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2Plugin
extends AbstractPlugin<OAuth2Plugin> {
    @Autowired
    @Qualifier(value="oauth2-plugin.client-authentication-manager")
    private AuthenticationManager clientAuthenticationManager;
    @Autowired
    @Qualifier(value="oauth2-plugin.client-details-service")
    private ClientDetailsService clientDetailsService;
    @Autowired
    @Qualifier(value="oauth2-plugin.authentication-manager")
    private OAuth2AuthenticationManager oauth2AuthenticationManager;
    private TokenGranter tokenGranter;
    @Autowired
    @Qualifier(value="oauth2-plugin.token-services")
    private AuthorizationServerTokenServices tokenServices;

    public static OAuth2Plugin getInstance() {
        return (OAuth2Plugin)((Object)Play.application().plugin(OAuth2Plugin.class));
    }

    public OAuth2Plugin(Application application) {
        super(application);
    }

    public AuthenticationManager getClientAuthenticationManager() {
        return this.clientAuthenticationManager;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public AuthenticationManager getOAuth2AuthenticationManager() {
        return this.oauth2AuthenticationManager;
    }

    public TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    public AuthorizationServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void onStart() {
        super.onStart();
        this.tokenGranter = (TokenGranter)this.getApplicationContext().getBean(TokenGranter.class);
    }
}

