/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.mongodb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import me.tfeng.play.mongodb.MongoDbTypeConverter;
import me.tfeng.play.mongodb.RecordConverter;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.Utf8;
import org.bson.types.Binary;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DBObjectDecoder
extends Decoder {
    private static final Logger.ALogger LOG = Logger.of(DBObjectDecoder.class);
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    private final SpecificData data;
    private final Stack<Iterator<Object>> iteratorStack = new Stack();
    private final Stack<Schema> schemaStack = new Stack();

    public DBObjectDecoder(Class<?> recordClass, Object object) {
        try {
            this.data = new SpecificData(recordClass.getClassLoader());
            this.pushToStacks(this.data.getSchema(recordClass), object);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize decoder", e);
        }
    }

    public DBObjectDecoder(Schema schema, Object object, ClassLoader classLoader) {
        try {
            this.data = new SpecificData(classLoader);
            this.pushToStacks(schema, object);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize decoder", e);
        }
    }

    public long arrayNext() throws IOException {
        try {
            if (this.iteratorStack.peek().hasNext()) {
                long l = 1L;
                return l;
            }
            this.popFromStacks();
            long l = 0L;
            return l;
        }
        finally {
            this.finishRead();
        }
    }

    public long mapNext() throws IOException {
        return this.arrayNext();
    }

    public long readArrayStart() throws IOException {
        this.jumpToNextField();
        return this.arrayNext();
    }

    public boolean readBoolean() throws IOException {
        this.jumpToNextField();
        try {
            boolean bl = (Boolean)this.iteratorStack.peek().next();
            return bl;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        this.jumpToNextField();
        try {
            Object next = this.iteratorStack.peek().next();
            if (next == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            if (next instanceof Binary) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(((Binary)next).getData());
                return byteBuffer;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])next);
            return byteBuffer;
        }
        finally {
            this.finishRead();
        }
    }

    public double readDouble() throws IOException {
        this.jumpToNextField();
        try {
            double d = ((Number)this.iteratorStack.peek().next()).doubleValue();
            return d;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readEnum() throws IOException {
        this.jumpToNextField();
        try {
            String value = (String)this.iteratorStack.peek().next();
            Schema schema = this.schemaStack.peek();
            if (schema.getType() != Schema.Type.ENUM) {
                throw new IOException("Enum type is expected, but the current type is " + schema.getType());
            }
            int index = schema.getEnumSymbols().indexOf(value);
            if (index < 0) {
                throw new IOException(value + " is not a valid value in enum " + schema);
            }
            int n = index;
            return n;
        }
        finally {
            this.finishRead();
        }
    }

    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        ByteBuffer buffer = this.readBytes(null);
        byte[] data = buffer.array();
        if (data.length != length) {
            throw new IOException("Binary data of length " + length + " is expected; actual length is " + data.length);
        }
        System.arraycopy(data, 0, bytes, start, length);
    }

    public float readFloat() throws IOException {
        this.jumpToNextField();
        try {
            float f = ((Number)this.iteratorStack.peek().next()).floatValue();
            return f;
        }
        finally {
            this.finishRead();
        }
    }

    public int readIndex() throws IOException {
        this.jumpToNextField();
        Object value = this.iteratorStack.peek().next();
        Schema schema = this.schemaStack.peek();
        List types = schema.getTypes();
        if (types.size() != 2 || !types.stream().anyMatch(type -> type.getType() == Schema.Type.NULL)) {
            throw new IOException("MongoDb plugin can only handle union of null and one other type; schema " + schema + " is not supported");
        }
        Schema actualSchema = value == null ? (((Schema)types.get(0)).getType() == Schema.Type.NULL ? (Schema)types.get(0) : (Schema)types.get(1)) : (((Schema)types.get(0)).getType() != Schema.Type.NULL ? (Schema)types.get(0) : (Schema)types.get(1));
        this.pushToStacks(actualSchema, value);
        return actualSchema == types.get(0) ? 0 : 1;
    }

    public int readInt() throws IOException {
        this.jumpToNextField();
        try {
            int n = ((Number)this.iteratorStack.peek().next()).intValue();
            return n;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws IOException {
        this.jumpToNextField();
        try {
            Object object = this.iteratorStack.peek().next();
            if (object instanceof Number) {
                long l = ((Number)object).longValue();
                return l;
            }
            long l = MongoDbTypeConverter.convertFromMongoDbType(Long.class, object);
            return l;
        }
        finally {
            this.finishRead();
        }
    }

    public long readMapStart() throws IOException {
        this.jumpToNextField();
        return this.mapNext();
    }

    public void readNull() throws IOException {
        this.jumpToNextField();
        try {
            if (this.iteratorStack.peek().next() != null) {
                throw new IOException("Null value is expected");
            }
        }
        finally {
            this.finishRead();
        }
    }

    public String readString() throws IOException {
        this.jumpToNextField();
        try {
            String string = MongoDbTypeConverter.convertFromMongoDbType(String.class, this.iteratorStack.peek().next());
            return string;
        }
        finally {
            this.finishRead();
        }
    }

    public Utf8 readString(Utf8 old) throws IOException {
        String string = this.readString();
        return string == null ? null : (old == null ? new Utf8(string) : old.set(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skipArray() throws IOException {
        long result = this.readArrayStart();
        try {
            Iterator<Object> iterator = this.iteratorStack.peek();
            while (result > 0L) {
                iterator.next();
                result = this.arrayNext();
            }
        }
        finally {
            this.finishRead();
        }
        return 0L;
    }

    public void skipBytes() throws IOException {
        this.jumpToNextField();
        try {
            this.iteratorStack.peek().next();
        }
        finally {
            this.finishRead();
        }
    }

    public void skipFixed(int length) throws IOException {
        this.jumpToNextField();
        try {
            this.iteratorStack.peek().next();
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skipMap() throws IOException {
        long result = this.readMapStart();
        try {
            Iterator<Object> iterator = this.iteratorStack.peek();
            while (result > 0L) {
                iterator.next();
                iterator.next();
                result = this.mapNext();
            }
        }
        finally {
            this.finishRead();
        }
        return 0L;
    }

    public void skipString() throws IOException {
        this.jumpToNextField();
        try {
            this.iteratorStack.peek().next();
        }
        finally {
            this.finishRead();
        }
    }

    private void finishRead() {
        Schema.Type type;
        while (!this.iteratorStack.isEmpty() && !this.iteratorStack.peek().hasNext() && (type = this.schemaStack.peek().getType()) != Schema.Type.ARRAY && type != Schema.Type.MAP) {
            this.popFromStacks();
        }
    }

    private boolean jumpToNextField() throws IOException {
        Schema schema = this.schemaStack.peek();
        switch (schema.getType()) {
            case ARRAY: {
                this.pushToStacks(this.schemaStack.peek().getElementType(), this.iteratorStack.peek().next());
                return true;
            }
            case MAP: {
                MapIterator iterator = (MapIterator)this.iteratorStack.peek();
                if (iterator.isNextKey()) {
                    this.pushToStacks(STRING_SCHEMA, this.iteratorStack.peek().next());
                } else {
                    this.pushToStacks(this.schemaStack.peek().getValueType(), this.iteratorStack.peek().next());
                }
                return true;
            }
            case RECORD: {
                RecordIterator iterator = (RecordIterator)this.iteratorStack.peek();
                boolean reachedNextField = false;
                while (!reachedNextField && iterator.hasNext()) {
                    Object value = iterator.next();
                    Schema.Field field = iterator.getCurrentField();
                    Schema.Type type = field.schema().getType();
                    this.pushToStacks(field.schema(), value);
                    if (type == Schema.Type.RECORD) {
                        reachedNextField = this.jumpToNextField();
                        if (reachedNextField) continue;
                        this.popFromStacks();
                        continue;
                    }
                    reachedNextField = true;
                }
                if (reachedNextField) {
                    return true;
                }
                this.popFromStacks();
                return this.jumpToNextField();
            }
        }
        return true;
    }

    private void popFromStacks() {
        this.schemaStack.pop();
        this.iteratorStack.pop();
    }

    private void pushToStacks(Schema schema, Object object) throws IOException {
        switch (schema.getType()) {
            case ARRAY: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(((List)object).iterator());
                break;
            }
            case MAP: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(new MapIterator(object));
                break;
            }
            case RECORD: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(new RecordIterator(schema, object));
                break;
            }
            case UNION: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(Collections.singletonList(object).iterator());
                break;
            }
            default: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(Collections.singletonList(object).iterator());
            }
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class RecordIterator
    implements Iterator<Object> {
        private Schema.Field currentField;
        private final Iterator<Schema.Field> fieldIterator;
        private Map<String, String> fieldNameMap;
        private final Map<String, Object> map;

        public RecordIterator(Schema schema, Object object) {
            this.fieldIterator = schema.getFields().iterator();
            this.map = (Map)object;
            this.initializeFieldNameMap(schema);
        }

        public Schema.Field getCurrentField() {
            return this.currentField;
        }

        @Override
        public boolean hasNext() {
            return this.fieldIterator.hasNext();
        }

        @Override
        public Object next() {
            this.currentField = this.fieldIterator.next();
            String schemaFieldName = this.currentField.name();
            String dbFieldName = this.fieldNameMap.get(schemaFieldName);
            return this.map.get(dbFieldName == null ? schemaFieldName : dbFieldName);
        }

        private void initializeFieldNameMap(Schema schema) {
            Class recordClass = DBObjectDecoder.this.data.getClass(schema);
            if (recordClass == null) {
                LOG.warn("Unable to load class " + SpecificData.getClassName((Schema)schema) + "; skipping java annotation processing");
                this.fieldNameMap = Collections.emptyMap();
            } else {
                List fields = schema.getFields();
                this.fieldNameMap = new HashMap<String, String>(fields.size());
                for (Schema.Field field : fields) {
                    String dbFieldName;
                    String schemaFieldName = field.name();
                    if (schemaFieldName.equals(dbFieldName = RecordConverter.getFieldName(field))) continue;
                    this.fieldNameMap.put(schemaFieldName, dbFieldName);
                }
            }
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class MapIterator
    implements Iterator<Object> {
        private Map.Entry<String, Object> currentEntry;
        private final Iterator<Map.Entry<String, Object>> iterator;

        public MapIterator(Object object) {
            this.iterator = ((Map)object).entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentEntry != null || this.iterator.hasNext();
        }

        public boolean isNextKey() {
            return this.currentEntry == null;
        }

        @Override
        public Object next() {
            if (this.currentEntry == null) {
                this.currentEntry = this.iterator.next();
                return this.currentEntry.getKey();
            }
            Object value = this.currentEntry.getValue();
            this.currentEntry = null;
            return value;
        }
    }
}

