/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.mongodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.tfeng.play.mongodb.DBObjectDecoder;
import me.tfeng.play.mongodb.MongoDbTypeConverter;
import me.tfeng.play.mongodb.MongoType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.bson.types.Binary;
import org.mortbay.util.ajax.JSON;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RecordConverter {
    public static final String MONGO_CLASS_PROPERTY = "mongo-class";
    public static final String MONGO_NAME_PROPERTY = "mongo-name";
    public static final String MONGO_TYPE_PROPERTY = "mongo-type";
    private static final JsonNodeFactory NODE_FACTORY = new JsonNodeFactory(false);

    public static JsonNode toAvroJson(Schema schema, Object dbObject) {
        switch (schema.getType()) {
            case NULL: {
                return NODE_FACTORY.nullNode();
            }
            case ENUM: 
            case FIXED: 
            case STRING: {
                return NODE_FACTORY.textNode((String)dbObject);
            }
            case BOOLEAN: {
                return NODE_FACTORY.booleanNode(((Boolean)dbObject).booleanValue());
            }
            case INT: {
                return NODE_FACTORY.numberNode(((Number)dbObject).intValue());
            }
            case LONG: {
                return NODE_FACTORY.numberNode(((Number)dbObject).longValue());
            }
            case FLOAT: {
                return NODE_FACTORY.numberNode(((Number)dbObject).floatValue());
            }
            case DOUBLE: {
                return NODE_FACTORY.numberNode(((Number)dbObject).doubleValue());
            }
            case ARRAY: {
                List list = (List)dbObject;
                ArrayNode arrayNode = NODE_FACTORY.arrayNode();
                list.forEach(element -> arrayNode.add(RecordConverter.toAvroJson(schema.getElementType(), element)));
                return arrayNode;
            }
            case MAP: {
                Map map = (Map)dbObject;
                ObjectNode mapNode = NODE_FACTORY.objectNode();
                map.entrySet().forEach(entry -> mapNode.put((String)entry.getKey(), RecordConverter.toAvroJson(schema.getValueType(), entry.getValue())));
                return mapNode;
            }
            case RECORD: {
                Map map = (Map)dbObject;
                ObjectNode recordNode = NODE_FACTORY.objectNode();
                for (Schema.Field field : schema.getFields()) {
                    Object value = map.get(field.name());
                    if (value == null) {
                        recordNode.put(field.name(), (JsonNode)NullNode.instance);
                        continue;
                    }
                    recordNode.put(field.name(), RecordConverter.toAvroJson(field.schema(), value));
                }
                return recordNode;
            }
            case UNION: {
                List types = schema.getTypes();
                if (types.size() != 2 || !types.stream().anyMatch(type -> type.getType() == Schema.Type.NULL)) {
                    throw new RuntimeException("MongoDb plugin can only handle union of null and one other type; schema " + schema + " is not supported");
                }
                Schema actualSchema = ((Schema)types.get(0)).getType() == Schema.Type.NULL ? (Schema)types.get(1) : (Schema)types.get(0);
                ObjectNode mapNode = NODE_FACTORY.objectNode();
                mapNode.put(actualSchema.getFullName(), RecordConverter.toAvroJson(actualSchema, dbObject));
                return mapNode;
            }
            case BYTES: {
                return NODE_FACTORY.binaryNode((byte[])dbObject);
            }
        }
        throw new RuntimeException("Unknown Avro type " + schema.getType());
    }

    public static DBObject toDbObject(IndexedRecord record) {
        BasicDBObject dbObject = new BasicDBObject();
        Schema schema = record.getSchema();
        for (Schema.Field field : schema.getFields()) {
            Object value = record.get(field.pos());
            if (value == null) continue;
            dbObject.put(RecordConverter.getFieldName(field), RecordConverter.getDbObject(field.schema(), value));
        }
        return dbObject;
    }

    public static <T extends IndexedRecord> T toRecord(Class<T> recordClass, DBObject dbObject) {
        SpecificDatumReader reader = new SpecificDatumReader(recordClass);
        try {
            DBObjectDecoder decoder = new DBObjectDecoder(recordClass, dbObject);
            return (T)((IndexedRecord)reader.read(null, (Decoder)decoder));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert MongoDB object " + dbObject + " into Avro record", e);
        }
    }

    public static GenericData.Record toRecord(Schema schema, DBObject object, ClassLoader classLoader) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericData.Record)reader.read(null, (Decoder)new DBObjectDecoder(schema, object, classLoader));
    }

    protected static String getFieldName(Schema.Field field) {
        String mongoName = field.getProp(MONGO_NAME_PROPERTY);
        if (mongoName != null) {
            return mongoName;
        }
        return field.name();
    }

    private static Object getDbObject(Schema schema, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IndexedRecord) {
            return RecordConverter.toDbObject((IndexedRecord)object);
        }
        if (object instanceof Collection) {
            return RecordConverter.getDbObjects(schema, (Collection)object);
        }
        if (object instanceof Map) {
            return RecordConverter.getDbObjects(schema, (Map)object);
        }
        if (object instanceof ByteBuffer) {
            return new Binary(((ByteBuffer)object).array());
        }
        String mongoClassName = schema.getProp(MONGO_CLASS_PROPERTY);
        String mongoType = schema.getProp(MONGO_TYPE_PROPERTY);
        if (object instanceof CharSequence) {
            object = ((CharSequence)object).toString();
        }
        if (mongoClassName == null && mongoType == null) {
            return object;
        }
        if (mongoClassName != null && mongoType != null) {
            throw new RuntimeException("mongo-class and mongo-type should not be both specified: " + schema);
        }
        try {
            Class<Object> mongoClass = mongoClassName != null ? schema.getClass().getClassLoader().loadClass(mongoClassName) : MongoType.valueOf(mongoType).getMongoClass();
            if (object instanceof String && mongoClass.isAssignableFrom(Object.class)) {
                return JSON.parse((String)((String)object));
            }
            return MongoDbTypeConverter.convertToMongoDbType(mongoClass, object);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load mongo-class " + mongoClassName, e);
        }
    }

    private static List<Object> getDbObjects(Schema schema, Collection<Object> collection) {
        return collection.stream().map(object -> RecordConverter.getDbObject(schema.getElementType(), object)).collect(Collectors.toList());
    }

    private static Map<String, Object> getDbObjects(Schema schema, Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
        map.entrySet().forEach(entry -> newMap.put((String)entry.getKey(), RecordConverter.getDbObject(schema.getValueType(), entry.getValue())));
        return newMap;
    }
}

