/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.mongodb;

import com.google.common.collect.ImmutableMap;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MongoDbTypeConverter {
    public static final Map<Pair<Class<?>, Class<?>>, Converter<?, ?>> CONVERTER_MAP = ImmutableMap.builder().put((Object)ImmutablePair.of(BSONTimestamp.class, Long.class), (Object)new BSONTimestampToLongConverter()).put((Object)ImmutablePair.of(BSONTimestamp.class, String.class), (Object)new BSONTimestampToStringConverter()).put((Object)ImmutablePair.of(Date.class, Long.class), (Object)new DateToLongConverter()).put((Object)ImmutablePair.of(Date.class, String.class), (Object)new DateToStringConverter()).put((Object)ImmutablePair.of(ObjectId.class, String.class), (Object)new ObjectIdToStringConverter()).build();
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\(([0-9]+),\\s*([0-9]+)\\)");

    public static <S, T> T convertFromMongoDbType(Class<T> dataClass, S object) {
        if (object == null) {
            return null;
        }
        if (dataClass.isInstance(object)) {
            return dataClass.cast(object);
        }
        Converter<?, ?> converter = CONVERTER_MAP.get(ImmutablePair.of(object.getClass(), dataClass));
        if (converter != null) {
            return (T)converter.convertFromMongoDbType(object);
        }
        if (String.class.isAssignableFrom(dataClass) && object instanceof DBObject) {
            return dataClass.cast(JSON.serialize(object));
        }
        return null;
    }

    public static <S, T> S convertToMongoDbType(Class<S> mongoClass, T data) {
        if (data == null) {
            return null;
        }
        if (mongoClass.isInstance(data)) {
            return mongoClass.cast(data);
        }
        Converter<?, ?> converter = CONVERTER_MAP.get(ImmutablePair.of(mongoClass, data.getClass()));
        if (converter != null) {
            return (S)converter.convertToMongoDbType(data);
        }
        if (DBObject.class.isAssignableFrom(mongoClass) && data instanceof String) {
            return mongoClass.cast(JSON.parse((String)((String)data)));
        }
        return null;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class ObjectIdToStringConverter
    implements Converter<ObjectId, String> {
        @Override
        public String convertFromMongoDbType(ObjectId objectId) {
            return objectId.toString();
        }

        @Override
        public ObjectId convertToMongoDbType(String data) {
            return new ObjectId(data);
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class DateToStringConverter
    implements Converter<Date, String> {
        @Override
        public String convertFromMongoDbType(Date object) {
            return DATE_FORMAT.format(object);
        }

        @Override
        public Date convertToMongoDbType(String data) {
            try {
                return DATE_FORMAT.parse(data);
            }
            catch (ParseException e) {
                throw new RuntimeException("String does not confirm to date format: " + data);
            }
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class DateToLongConverter
    implements Converter<Date, Long> {
        @Override
        public Long convertFromMongoDbType(Date data) {
            return data.getTime();
        }

        @Override
        public Date convertToMongoDbType(Long object) {
            return new Date(object);
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static interface Converter<S, T> {
        public T convertFromMongoDbType(S var1);

        public S convertToMongoDbType(T var1);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class BSONTimestampToStringConverter
    implements Converter<BSONTimestamp, String> {
        @Override
        public String convertFromMongoDbType(BSONTimestamp timestamp) {
            return "(" + timestamp.getTime() + ", " + timestamp.getInc() + ")";
        }

        @Override
        public BSONTimestamp convertToMongoDbType(String data) {
            Matcher matcher = TIMESTAMP_PATTERN.matcher(data);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid BSONTimestamp " + data);
            }
            int time = Integer.parseInt(matcher.group(1));
            int inc = Integer.parseInt(matcher.group(2));
            return new BSONTimestamp(time, inc);
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class BSONTimestampToLongConverter
    implements Converter<BSONTimestamp, Long> {
        @Override
        public Long convertFromMongoDbType(BSONTimestamp data) {
            int inc = data.getInc();
            if (inc < 0 || inc >= 1000) {
                throw new RuntimeException("Overflow occurs while converting BSONTimestamp into long: " + data);
            }
            return (long)data.getTime() * 1000L + (long)inc;
        }

        @Override
        public BSONTimestamp convertToMongoDbType(Long object) {
            return new BSONTimestamp((int)(object / 1000L), (int)(object % 1000L));
        }
    }
}

