/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.mongodb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LoggingDecoder
extends Decoder {
    private static final Logger.ALogger LOG = Logger.of(LoggingDecoder.class);
    private final Decoder decoder;

    public LoggingDecoder(Decoder decoder) throws IOException {
        this.decoder = decoder;
    }

    public long arrayNext() throws IOException {
        long result = this.decoder.arrayNext();
        LOG.info("arrayNext() = " + result);
        return result;
    }

    public long mapNext() throws IOException {
        long result = this.decoder.mapNext();
        LOG.info("mapNext() = " + result);
        return result;
    }

    public long readArrayStart() throws IOException {
        long result = this.decoder.readArrayStart();
        LOG.info("readArrayStart() = " + result);
        return result;
    }

    public boolean readBoolean() throws IOException {
        boolean result = this.decoder.readBoolean();
        LOG.info("readBoolean() = " + result);
        return result;
    }

    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        ByteBuffer result = this.decoder.readBytes(old);
        LOG.info("readBytes(...) = ...");
        return result;
    }

    public double readDouble() throws IOException {
        double result = this.decoder.readDouble();
        LOG.info("readDouble() = " + result);
        return result;
    }

    public int readEnum() throws IOException {
        int result = this.decoder.readEnum();
        LOG.info("readEnum() = " + result);
        return result;
    }

    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        this.decoder.readFixed(bytes, start, length);
        LOG.info("readFixed(..., " + start + ", " + length + ")");
    }

    public float readFloat() throws IOException {
        float result = this.decoder.readFloat();
        LOG.info("readFloat() = " + result);
        return result;
    }

    public int readIndex() throws IOException {
        int result = this.decoder.readIndex();
        LOG.info("readIndex() = " + result);
        return result;
    }

    public int readInt() throws IOException {
        int result = this.decoder.readInt();
        LOG.info("readInt() = " + result);
        return result;
    }

    public long readLong() throws IOException {
        long result = this.decoder.readLong();
        LOG.info("readLong() = " + result);
        return result;
    }

    public long readMapStart() throws IOException {
        long result = this.decoder.readMapStart();
        LOG.info("readMapStart() = " + result);
        return result;
    }

    public void readNull() throws IOException {
        this.decoder.readNull();
        LOG.info("readNull()");
    }

    public String readString() throws IOException {
        String result = this.decoder.readString();
        LOG.info("readString() = " + result);
        return result;
    }

    public Utf8 readString(Utf8 old) throws IOException {
        Utf8 result = this.decoder.readString(old);
        LOG.info("readString(" + old + ") = " + result);
        return result;
    }

    public long skipArray() throws IOException {
        long result = this.decoder.skipArray();
        LOG.info("skipArray() = " + result);
        return result;
    }

    public void skipBytes() throws IOException {
        this.decoder.skipBytes();
        LOG.info("skipBytes()");
    }

    public void skipFixed(int length) throws IOException {
        this.decoder.skipFixed(length);
        LOG.info("skipFixed(" + length + ")");
    }

    public long skipMap() throws IOException {
        long result = this.decoder.skipMap();
        LOG.info("skipMap() = " + result);
        return result;
    }

    public void skipString() throws IOException {
        this.decoder.skipString();
        LOG.info("skipString()");
    }
}

