/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.kafka;

import java.io.IOException;
import java.nio.charset.Charset;
import kafka.serializer.Decoder;
import kafka.utils.VerifiableProperties;
import me.tfeng.play.avro.AvroHelper;
import org.apache.avro.generic.IndexedRecord;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroDecoder<T extends IndexedRecord>
implements Decoder<T> {
    private Class<? extends T> recordClass;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public AvroDecoder() {
        this((VerifiableProperties)null);
    }

    public AvroDecoder(Class<T> recordClass) {
        this((VerifiableProperties)null);
        this.recordClass = recordClass;
    }

    public AvroDecoder(VerifiableProperties verifiableProperties) {
    }

    public T fromBytes(byte[] data) {
        try {
            return (T)((IndexedRecord)AvroHelper.decodeRecord(this.recordClass, (byte[])data));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decode Kafka event " + new String(data, UTF8));
        }
    }

    public AvroDecoder<T> setRecordClass(Class<? extends T> recordClass) {
        this.recordClass = recordClass;
        return this;
    }
}

