/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import akka.dispatch.ExecutionContexts;
import akka.dispatch.Futures;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import me.tfeng.play.plugins.AbstractPlugin;
import org.springframework.beans.factory.annotation.Value;
import org.webjars.WebJarAssetLocator;
import play.Application;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DustPlugin
extends AbstractPlugin {
    private static final String DUST_JS_NAME = "dust-full.min.js";
    private static final Logger.ALogger LOG = Logger.of(DustPlugin.class);
    private static final String RENDER_SCRIPT = "dust.render(name, JSON.parse(json), function(err, data) {if (err) throw new Error(err); else writer.write(data, 0, data.length); })";
    private WebJarAssetLocator assetLocator;
    private ConcurrentLinkedQueue<ScriptEngine> engines;
    private ExecutionContextExecutorService executionContext;
    private ThreadPoolExecutor executor;
    @Value(value="${dust-plugin.js-engine-pool-size:4}")
    private int jsEnginePoolSize;
    @Value(value="${dust-plugin.js-engine-pool-timeout-ms:10000}")
    private long jsEnginePoolTimeoutMs;
    private final ObjectMapper mapper = new ObjectMapper();
    private BlockingQueue<Runnable> queue;
    @Value(value="${dust-plugin.templates-directory:templates}")
    private String templatesDirectory;

    public static DustPlugin getInstance() {
        return (DustPlugin)((Object)Play.application().plugin(DustPlugin.class));
    }

    public DustPlugin(Application application) throws ScriptException {
        super(application);
    }

    public void onStart() {
        super.onStart();
        this.assetLocator = new WebJarAssetLocator(WebJarAssetLocator.getFullPathIndex((Pattern)Pattern.compile(".*\\.js$"), (ClassLoader[])new ClassLoader[]{this.getApplication().classloader()}));
        this.engines = new ConcurrentLinkedQueue();
        for (int i = 0; i < this.jsEnginePoolSize; ++i) {
            ScriptEngine engine = new ScriptEngineManager(null).getEngineByName("nashorn");
            this.initializeScriptEngine(engine);
            this.engines.offer(engine);
        }
        this.queue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(this.jsEnginePoolSize, this.jsEnginePoolSize, this.jsEnginePoolTimeoutMs, TimeUnit.MILLISECONDS, this.queue);
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                LOG.warn("JS engine rejected a request; executor " + executor);
            }
        });
        this.executionContext = ExecutionContexts.fromExecutorService((ExecutorService)this.executor);
    }

    public F.Promise<String> render(String template, JsonNode data) {
        Future future = Futures.future(() -> {
            ScriptEngine engine = this.engines.poll();
            try {
                boolean isRegistered = (Boolean)this.evaluate(engine, "dust.cache[template] !== undefined", (Map<String, Object>)ImmutableMap.of((Object)"template", (Object)template));
                if (!isRegistered) {
                    String jsFileName = this.templatesDirectory + "/" + template + ".js";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading template " + jsFileName);
                    }
                    InputStream jsStream = this.getApplication().classloader().getResourceAsStream(this.assetLocator.getFullPath(jsFileName));
                    String compiledTemplate = this.readAndClose(jsStream);
                    this.evaluate(engine, "dust.loadSource(source)", (Map<String, Object>)ImmutableMap.of((Object)"source", (Object)compiledTemplate));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Rendering template " + template);
                }
                String json = this.mapper.writeValueAsString((Object)data);
                StringWriter writer = new StringWriter();
                this.evaluate(engine, RENDER_SCRIPT, (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)template, (Object)"json", (Object)json, (Object)"writer", (Object)writer));
                String string2 = writer.toString();
                return string2;
            }
            finally {
                this.engines.add(engine);
            }
        }, (ExecutionContext)this.executionContext);
        return F.Promise.wrap((Future)future);
    }

    private Object evaluate(ScriptEngine engine, String script, Map<String, Object> data) throws ScriptException {
        SimpleBindings bindings = new SimpleBindings(data);
        engine.getContext().setBindings(bindings, 200);
        return engine.eval(script);
    }

    private void initializeScriptEngine(ScriptEngine engine) {
        String dustJsPath = this.assetLocator.getFullPath(DUST_JS_NAME);
        String dustJs = this.readAndClose(this.getApplication().classloader().getResourceAsStream(dustJsPath));
        try {
            engine.eval(dustJs);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Unable to initialize script engine", e);
        }
    }

    private String readAndClose(InputStream stream) {
        try {
            String string = CharStreams.toString((Readable)new InputStreamReader(stream, Charset.forName("utf8")));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close stream", e);
            }
        }
    }
}

