/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.plugins.AvroPlugin;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AsyncResponder
extends SpecificResponder {
    private static final Method HANDSHAKE_METHOD;
    private static final Schema META;
    private static final GenericDatumReader<Map<String, ByteBuffer>> META_READER;
    private static final GenericDatumWriter<Map<String, ByteBuffer>> META_WRITER;
    private final Object impl;

    public AsyncResponder(Class<?> iface, Object impl) {
        super(iface, impl);
        this.impl = impl;
    }

    public AsyncResponder(Class<?> iface, Object impl, SpecificData data) {
        super(iface, impl, data);
        this.impl = impl;
    }

    public AsyncResponder(Protocol protocol, Object impl) {
        super(protocol, impl);
        this.impl = impl;
    }

    public AsyncResponder(Protocol protocol, Object impl, SpecificData data) {
        super(protocol, impl, data);
        this.impl = impl;
    }

    public F.Promise<List<ByteBuffer>> asyncRespond(List<ByteBuffer> buffers) throws Exception {
        BinaryDecoder in = DecoderFactory.get().binaryDecoder((InputStream)new ByteBufferInputStream(buffers), null);
        ByteBufferOutputStream bbo = new ByteBufferOutputStream();
        BinaryEncoder out = EncoderFactory.get().binaryEncoder((OutputStream)bbo, null);
        RPCContext context = new RPCContext();
        List payload = null;
        List handshake = null;
        Protocol remote = (Protocol)HANDSHAKE_METHOD.invoke((Object)this, in, out, null);
        out.flush();
        if (remote == null) {
            return F.Promise.pure((Object)bbo.getBufferList());
        }
        handshake = bbo.getBufferList();
        context.setRequestCallMeta((Map)META_READER.read(null, (Decoder)in));
        String messageName = in.readString(null).toString();
        if (messageName.equals("")) {
            return F.Promise.pure((Object)handshake);
        }
        Protocol.Message rm = (Protocol.Message)remote.getMessages().get(messageName);
        if (rm == null) {
            throw new AvroRuntimeException("No such remote message: " + messageName);
        }
        Protocol.Message m = (Protocol.Message)this.getLocal().getMessages().get(messageName);
        if (m == null) {
            throw new AvroRuntimeException("No message named " + messageName + " in " + this.getLocal());
        }
        Object request = this.readRequest(rm.getRequest(), m.getRequest(), (Decoder)in);
        context.setMessage(rm);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverReceiveRequest(context);
        }
        List handshakeFinal = handshake;
        if (AvroHelper.isAvroClient(this.impl.getClass())) {
            F.Promise promise = (F.Promise)this.respond(m, request);
            return promise.map(result -> {
                context.setResponse(result);
                this.processResult(bbo, out, context, m, payload, handshakeFinal, result, null);
                return bbo.getBufferList();
            }).recover(e -> {
                if (e instanceof Exception) {
                    context.setError((Exception)e);
                    this.processResult(bbo, out, context, m, payload, handshakeFinal, null, (Exception)e);
                    return bbo.getBufferList();
                }
                throw e;
            });
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return F.Promise.promise(() -> {
            Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
            SecurityContextHolder.getContext().setAuthentication(authentication);
            try {
                Object result = this.respond(m, request);
                context.setResponse(result);
                this.processResult(bbo, out, context, m, payload, handshakeFinal, result, null);
            }
            catch (Exception e) {
                context.setError(e);
                this.processResult(bbo, out, context, m, payload, handshakeFinal, null, e);
            }
            finally {
                SecurityContextHolder.getContext().setAuthentication(currentAuthentication);
            }
            return bbo.getBufferList();
        }, (ExecutionContext)AvroPlugin.getInstance().getExecutionContext());
    }

    private void processResult(ByteBufferOutputStream bbo, BinaryEncoder out, RPCContext context, Protocol.Message m, List<ByteBuffer> payload, List<ByteBuffer> handshake, Object response, Exception error) throws Exception {
        out.writeBoolean(error != null);
        if (error == null) {
            this.writeResponse(m.getResponse(), response, (Encoder)out);
        } else {
            try {
                this.writeError(m.getErrors(), error, (Encoder)out);
            }
            catch (AvroRuntimeException e) {
                throw error;
            }
        }
        out.flush();
        payload = bbo.getBufferList();
        context.setResponsePayload(payload);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverSendResponse(context);
        }
        META_WRITER.write((Object)context.responseCallMeta(), (Encoder)out);
        out.flush();
        bbo.prepend(handshake);
        bbo.append(payload);
    }

    static {
        META = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.BYTES));
        META_READER = new GenericDatumReader(META);
        META_WRITER = new GenericDatumWriter(META);
        try {
            HANDSHAKE_METHOD = Responder.class.getDeclaredMethod("handshake", Decoder.class, Encoder.class, Transceiver.class);
            HANDSHAKE_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Unable to get handshake method", e);
        }
    }
}

