/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import me.tfeng.play.http.PostRequestPreparer;
import me.tfeng.play.plugins.AbstractPlugin;
import org.apache.avro.ipc.AsyncHttpTransceiver;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.IpcRequestor;
import org.apache.avro.specific.SpecificData;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import play.Application;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import play.libs.HttpExecution;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroPlugin
extends AbstractPlugin {
    private static final Logger.ALogger LOG = Logger.of(AvroPlugin.class);
    private ExecutionContext executionContext;
    @Value(value="${avro-plugin.execution-context:play.akka.actor.default-dispatcher}")
    private String executionContextId;
    private Map<Class<?>, Object> protocolImplementations;

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver) {
        return AvroPlugin.client(interfaceClass, transceiver, new SpecificData(interfaceClass.getClassLoader()));
    }

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver, SpecificData data) {
        return AvroPlugin.client(interfaceClass, transceiver, data, null);
    }

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver, SpecificData data, PostRequestPreparer postRequestPreparer) {
        try {
            IpcRequestor requestor = new IpcRequestor(interfaceClass, transceiver, data);
            if (postRequestPreparer != null) {
                requestor.setPostRequestPreparer(postRequestPreparer);
            }
            return (T)Proxy.newProxyInstance(data.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)((Object)requestor));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create async client", e);
        }
    }

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver, PostRequestPreparer postRequestPreparer) {
        return AvroPlugin.client(interfaceClass, transceiver, new SpecificData(interfaceClass.getClassLoader()), postRequestPreparer);
    }

    public static <T> T client(Class<T> interfaceClass, URL url) {
        return AvroPlugin.client(interfaceClass, new AsyncHttpTransceiver(url));
    }

    public static <T> T client(Class<T> interfaceClass, URL url, SpecificData data) {
        return AvroPlugin.client(interfaceClass, (AsyncTransceiver)new AsyncHttpTransceiver(url), data);
    }

    public static <T> T client(Class<T> interfaceClass, URL url, SpecificData data, PostRequestPreparer postRequestPreparer) {
        return AvroPlugin.client(interfaceClass, new AsyncHttpTransceiver(url), data, postRequestPreparer);
    }

    public static <T> T client(Class<T> interfaceClass, URL url, PostRequestPreparer postRequestPreparer) {
        return AvroPlugin.client(interfaceClass, (AsyncTransceiver)new AsyncHttpTransceiver(url), postRequestPreparer);
    }

    public static AvroPlugin getInstance() {
        return (AvroPlugin)((Object)Play.application().plugin(AvroPlugin.class));
    }

    public AvroPlugin(Application application) {
        super(application);
    }

    public ExecutionContext getExecutionContext() {
        return HttpExecution.fromThread((ExecutionContext)this.executionContext);
    }

    public Map<Class<?>, Object> getProtocolImplementations() {
        return this.protocolImplementations;
    }

    public void onStart() {
        super.onStart();
        try {
            this.executionContext = Akka.system().dispatchers().lookup(this.executionContextId);
        }
        catch (Exception e) {
            LOG.warn("Unable to obtain execution context " + this.executionContextId + "; using default", (Throwable)e);
            this.executionContext = Akka.system().dispatchers().defaultGlobalDispatcher();
        }
        try {
            this.protocolImplementations = (Map)this.getApplicationContext().getBean("avro-plugin.protocol-implementations", Map.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.protocolImplementations = Collections.emptyMap();
        }
    }
}

