/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import me.tfeng.play.plugins.AvroPlugin;
import org.apache.avro.ipc.AsyncHttpTransceiver;
import org.apache.avro.ipc.AsyncResponder;
import org.apache.http.entity.ContentType;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BinaryIpcController
extends Controller {
    public static final String CONTENT_TYPE = "avro/binary";

    @BodyParser.Of(value=BodyParser.Raw.class)
    public static F.Promise<Result> post(String protocol) throws Throwable {
        String contentTypeHeader = BinaryIpcController.request().getHeader("content-type");
        ContentType contentType = ContentType.parse((String)contentTypeHeader);
        if (!CONTENT_TYPE.equals(contentType.getMimeType())) {
            throw new RuntimeException("Unable to handle content-type " + contentType + "; " + CONTENT_TYPE + " is expected");
        }
        AvroPlugin plugin = AvroPlugin.getInstance();
        Class<?> protocolClass = Play.application().classloader().loadClass(protocol);
        Object implementation = plugin.getProtocolImplementations().get(protocolClass);
        byte[] bytes = BinaryIpcController.request().body().asRaw().asBytes();
        List<ByteBuffer> buffers = AsyncHttpTransceiver.readBuffers(new ByteArrayInputStream(bytes));
        AsyncResponder responder = new AsyncResponder(protocolClass, implementation);
        F.Promise<List<ByteBuffer>> response = responder.asyncRespond(buffers);
        return response.map(result -> {
            try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
                AsyncHttpTransceiver.writeBuffers(result, outStream);
            }
            return Results.ok((byte[])outStream.toByteArray());
        });
    }
}

