/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.tfeng.play.avro.AvroClient;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroHelper {
    public static JsonNode convertFromSimpleRecord(Schema schema, JsonNode json) throws IOException {
        return AvroHelper.convertFromSimpleRecord(schema, json, new JsonNodeFactory(false));
    }

    public static String convertFromSimpleRecord(Schema schema, String json) throws IOException {
        if (json.isEmpty()) {
            return json;
        }
        JsonNode node = Json.parse((String)json);
        node = AvroHelper.convertFromSimpleRecord(schema, node);
        return node.toString();
    }

    public static JsonNode convertToSimpleRecord(Schema schema, JsonNode json) throws IOException {
        return AvroHelper.convertToSimpleRecord(schema, json, new JsonNodeFactory(false));
    }

    public static String convertToSimpleRecord(Schema schema, String json) throws IOException {
        if (json.isEmpty()) {
            return json;
        }
        JsonNode node = Json.parse((String)json);
        node = AvroHelper.convertToSimpleRecord(schema, node);
        return node.toString();
    }

    public static Protocol getProtocol(Class<?> interfaceClass) {
        return new SpecificData(interfaceClass.getClassLoader()).getProtocol(interfaceClass);
    }

    public static Schema getSchema(Class<?> schemaClass) {
        return new SpecificData(schemaClass.getClassLoader()).getSchema(schemaClass);
    }

    public static Schema getSimpleUnionType(Schema union) throws IOException {
        if (union.getType() != Schema.Type.UNION) {
            throw new IOException("Schema is not a union type: " + union);
        }
        List types = union.getTypes();
        if (types.size() == 2) {
            if (((Schema)types.get(0)).getType() == Schema.Type.NULL && ((Schema)types.get(1)).getType() != Schema.Type.NULL) {
                return (Schema)types.get(1);
            }
            if (((Schema)types.get(1)).getType() == Schema.Type.NULL && ((Schema)types.get(0)).getType() != Schema.Type.NULL) {
                return (Schema)types.get(0);
            }
        }
        return null;
    }

    public static boolean isAvroClient(Class<?> clientClass) {
        return clientClass.getAnnotation(AvroClient.class) != null;
    }

    public static String toJson(IndexedRecord record) throws IOException {
        Schema schema = record.getSchema();
        return AvroHelper.toJson(schema, record);
    }

    public static String toJson(Schema schema, Object object) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonGenerator generator = new JsonFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
        generator.useDefaultPrettyPrinter();
        SpecificDatumWriter writer = new SpecificDatumWriter(schema);
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, generator);
        writer.write(object, (Encoder)encoder);
        encoder.flush();
        String json = outputStream.toString();
        return AvroHelper.convertToSimpleRecord(schema, json);
    }

    public static <T> T toRecord(Class<T> recordClass, String json) throws IOException {
        Schema schema = AvroHelper.getSchema(recordClass);
        json = AvroHelper.convertFromSimpleRecord(schema, json);
        SpecificDatumReader reader = new SpecificDatumReader(recordClass);
        return (T)reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, json));
    }

    public static <T> T toRecord(Schema schema, String json) throws IOException {
        json = AvroHelper.convertFromSimpleRecord(schema, json);
        SpecificDatumReader reader = new SpecificDatumReader(schema);
        return (T)reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, json));
    }

    private static JsonNode convertFromSimpleRecord(Schema schema, JsonNode json, JsonNodeFactory factory) throws IOException {
        if (json.isObject() && schema.getType() == Schema.Type.RECORD) {
            ObjectNode node = (ObjectNode)json;
            ObjectNode newNode = factory.objectNode();
            for (Schema.Field field : schema.getFields()) {
                String fieldName = field.name();
                if (node.has(fieldName)) {
                    newNode.put(fieldName, AvroHelper.convertFromSimpleRecord(field.schema(), node.get(fieldName), factory));
                    continue;
                }
                if (field.defaultValue() != null) {
                    newNode.put(fieldName, Json.parse((String)field.defaultValue().toString()));
                    continue;
                }
                newNode.put(fieldName, (JsonNode)factory.nullNode());
            }
            return newNode;
        }
        if (json.isObject() && schema.getType() == Schema.Type.MAP) {
            ObjectNode node = (ObjectNode)json;
            ObjectNode newNode = factory.objectNode();
            Schema valueType = schema.getValueType();
            Iterator entries = node.fields();
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                newNode.put((String)entry.getKey(), AvroHelper.convertFromSimpleRecord(valueType, (JsonNode)entry.getValue(), factory));
            }
            return newNode;
        }
        if (schema.getType() == Schema.Type.UNION) {
            Schema type = AvroHelper.getSimpleUnionType(schema);
            if (type == null) {
                if (json.isNull()) {
                    return json;
                }
                ObjectNode node = (ObjectNode)json;
                Map.Entry entry = (Map.Entry)node.fields().next();
                for (Schema unionType : schema.getTypes()) {
                    if (!unionType.getFullName().equals(entry.getKey())) continue;
                    ObjectNode newNode = factory.objectNode();
                    newNode.put((String)entry.getKey(), AvroHelper.convertFromSimpleRecord(unionType, (JsonNode)entry.getValue(), factory));
                    return newNode;
                }
                throw new IOException("Unable to get schema for type " + (String)entry.getKey() + " in union");
            }
            if (json.isNull()) {
                return json;
            }
            ObjectNode newNode = factory.objectNode();
            newNode.put(type.getFullName(), AvroHelper.convertFromSimpleRecord(type, json, factory));
            return newNode;
        }
        if (json.isArray() && schema.getType() == Schema.Type.ARRAY) {
            ArrayNode node = (ArrayNode)json;
            ArrayNode newNode = factory.arrayNode();
            Iterator iterator = node.elements();
            while (iterator.hasNext()) {
                newNode.add(AvroHelper.convertFromSimpleRecord(schema.getElementType(), (JsonNode)iterator.next(), factory));
            }
            return newNode;
        }
        return json;
    }

    private static JsonNode convertToSimpleRecord(Schema schema, JsonNode json, JsonNodeFactory factory) throws IOException {
        if (json.isObject() && schema.getType() == Schema.Type.RECORD) {
            ObjectNode node = (ObjectNode)json;
            ObjectNode newNode = factory.objectNode();
            for (Schema.Field field : schema.getFields()) {
                JsonNode value;
                String fieldName = field.name();
                if (!node.has(fieldName) || (value = AvroHelper.convertToSimpleRecord(field.schema(), node.get(fieldName), factory)).isNull()) continue;
                newNode.put(fieldName, value);
            }
            return newNode;
        }
        if (json.isObject() && schema.getType() == Schema.Type.MAP) {
            ObjectNode node = (ObjectNode)json;
            ObjectNode newNode = factory.objectNode();
            Schema valueType = schema.getValueType();
            Iterator entries = node.fields();
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                JsonNode value = AvroHelper.convertToSimpleRecord(valueType, (JsonNode)entry.getValue(), factory);
                if (!value.isNull()) continue;
                newNode.put((String)entry.getKey(), value);
            }
            return newNode;
        }
        if (schema.getType() == Schema.Type.UNION) {
            Schema type = AvroHelper.getSimpleUnionType(schema);
            if (type == null) {
                if (json.isNull()) {
                    return json;
                }
                ObjectNode node = (ObjectNode)json;
                Map.Entry entry = (Map.Entry)node.fields().next();
                for (Schema unionType : schema.getTypes()) {
                    if (!unionType.getFullName().equals(entry.getKey())) continue;
                    ObjectNode newNode = factory.objectNode();
                    newNode.put((String)entry.getKey(), AvroHelper.convertToSimpleRecord(unionType, (JsonNode)entry.getValue(), factory));
                    return newNode;
                }
                throw new IOException("Unable to get schema for type " + (String)entry.getKey() + " in union");
            }
            if (json.isNull()) {
                return json;
            }
            return AvroHelper.convertToSimpleRecord(type, json.get(type.getFullName()), factory);
        }
        if (json.isArray() && schema.getType() == Schema.Type.ARRAY) {
            ArrayNode node = (ArrayNode)json;
            ArrayNode newNode = factory.arrayNode();
            Iterator iterator = node.elements();
            while (iterator.hasNext()) {
                newNode.add(AvroHelper.convertToSimpleRecord(schema.getElementType(), (JsonNode)iterator.next(), factory));
            }
            return newNode;
        }
        return json;
    }
}

