/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Semaphore;
import me.tfeng.play.http.PostRequestPreparer;
import me.tfeng.play.plugins.AvroPlugin;
import me.tfeng.play.plugins.HttpPlugin;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.ipc.AsyncHttpException;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.HttpTransceiver;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.ws.WSResponse;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AsyncHttpTransceiver
extends HttpTransceiver
implements AsyncTransceiver {
    private volatile F.Promise<WSResponse> promise;
    private final Semaphore semaphore = new Semaphore(1);
    private int timeout = HttpPlugin.getInstance().getRequestTimeout();
    private final URL url;

    public static List<ByteBuffer> readBuffers(InputStream in) throws IOException {
        return HttpTransceiver.readBuffers((InputStream)in);
    }

    public static void writeBuffers(List<ByteBuffer> buffers, OutputStream out) throws IOException {
        HttpTransceiver.writeBuffers(buffers, (OutputStream)out);
    }

    public AsyncHttpTransceiver(URL url) {
        super(url);
        this.url = url;
    }

    public F.Promise<List<ByteBuffer>> asyncReadBuffers() throws IOException {
        return this.promise.map(response -> {
            try {
                int status = response.getStatus();
                if (status >= 400) {
                    throw new AsyncHttpException(status, this.url);
                }
                InputStream stream = response.getBodyAsStream();
                return AsyncHttpTransceiver.readBuffers(stream);
            }
            catch (Throwable t) {
                throw new AvroRemoteException(t);
            }
        });
    }

    @Override
    public F.Promise<List<ByteBuffer>> asyncTransceive(List<ByteBuffer> request, PostRequestPreparer postRequestPreparer) throws IOException {
        return F.Promise.promise(() -> {
            this.semaphore.acquire();
            this.writeBuffers(request, postRequestPreparer);
            return this;
        }, (ExecutionContext)AvroPlugin.getInstance().getExecutionContext()).flatMap(transceiver -> transceiver.asyncReadBuffers().transform(result -> {
            asyncHttpTransceiver.semaphore.release();
            return result;
        }, throwable -> {
            asyncHttpTransceiver.semaphore.release();
            return throwable;
        }));
    }

    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        return (List)this.asyncReadBuffers().get((long)this.timeout);
    }

    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ByteBuffer> transceive(List<ByteBuffer> request, PostRequestPreparer postRequestPreparer) throws IOException {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to acquire lock", e);
        }
        try {
            this.writeBuffers(request, postRequestPreparer);
            List<ByteBuffer> list = this.readBuffers();
            return list;
        }
        finally {
            this.semaphore.release();
        }
    }

    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        this.writeBuffers(buffers, null);
    }

    public synchronized void writeBuffers(List<ByteBuffer> buffers, PostRequestPreparer postRequestPreparer) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AsyncHttpTransceiver.writeBuffers(buffers, outputStream);
        this.promise = this.postRequest(this.url, outputStream.toByteArray(), postRequestPreparer);
    }

    protected String getContentType() {
        return "avro/binary";
    }

    protected F.Promise<WSResponse> postRequest(URL url, byte[] body, PostRequestPreparer postRequestPreparer) throws IOException {
        return HttpPlugin.getInstance().postRequest(url, this.getContentType(), body, postRequestPreparer);
    }
}

