/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.plugins.AvroPlugin;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.http.entity.ContentType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.Json;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JsonIpcController
extends Controller {
    public static final String CONTENT_TYPE = "avro/json";
    private static final Logger.ALogger LOG = Logger.of(JsonIpcController.class);
    private static final Charset UTF8 = Charset.forName("utf-8");

    @BodyParser.Of(value=BodyParser.Raw.class)
    public static F.Promise<Result> post(String message, String protocol) throws Throwable {
        String contentTypeHeader = JsonIpcController.request().getHeader("content-type");
        ContentType contentType = ContentType.parse((String)contentTypeHeader);
        if (!CONTENT_TYPE.equals(contentType.getMimeType())) {
            throw new RuntimeException("Unable to handle content-type " + contentType + "; " + CONTENT_TYPE + " is expected");
        }
        AvroPlugin plugin = AvroPlugin.getInstance();
        Class<?> protocolClass = Play.application().classloader().loadClass(protocol);
        Object implementation = plugin.getProtocolImplementations().get(protocolClass);
        Protocol avroProtocol = AvroHelper.getProtocol(protocolClass);
        Protocol.Message avroMessage = (Protocol.Message)avroProtocol.getMessages().get(message);
        byte[] bytes = JsonIpcController.request().body().asRaw().asBytes();
        SpecificResponder responder = new SpecificResponder(protocolClass, implementation);
        Object request = JsonIpcController.getRequest((Responder)responder, avroMessage, bytes);
        if (AvroHelper.isAvroClient(protocolClass)) {
            F.Promise promise = (F.Promise)responder.respond(avroMessage, request);
            return promise.map(result -> Results.ok((String)AvroHelper.toJson(avroMessage.getResponse(), result))).recover(e -> {
                try {
                    LOG.warn("Exception thrown while processing request; returning bad request", e);
                    return Results.badRequest((String)AvroHelper.toJson(avroMessage.getErrors(), e));
                }
                catch (Exception e2) {
                    throw e;
                }
            });
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return F.Promise.promise(() -> {
            Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
            SecurityContextHolder.getContext().setAuthentication(authentication);
            try {
                Object result = responder.respond(avroMessage, request);
                Results.Status status = Results.ok((String)AvroHelper.toJson(avroMessage.getResponse(), result));
                return status;
            }
            catch (Exception e) {
                try {
                    LOG.warn("Exception thrown while processing request; returning bad request", (Throwable)e);
                    Results.Status status = Results.badRequest((String)AvroHelper.toJson(avroMessage.getErrors(), e));
                    return status;
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            finally {
                SecurityContextHolder.getContext().setAuthentication(currentAuthentication);
            }
        }, (ExecutionContext)AvroPlugin.getInstance().getExecutionContext());
    }

    private static Object getRequest(Responder responder, Protocol.Message message, byte[] data) throws IOException {
        Schema schema = message.getRequest();
        if (schema.getType() == Schema.Type.RECORD && schema.getFields().isEmpty()) {
            data = "{}".getBytes(UTF8);
        }
        JsonNode node = Json.parse((InputStream)new ByteArrayInputStream(data));
        node = AvroHelper.convertFromSimpleRecord(schema, node);
        return responder.readRequest(message.getRequest(), message.getRequest(), (Decoder)DecoderFactory.get().jsonDecoder(schema, node.toString()));
    }
}

