/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import me.tfeng.play.http.PostRequestPreparer;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.AuthTokenPreservingPostRequestPreparer;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.specific.SpecificData;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Controller;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IpcRequestor
extends SpecificRequestor {
    private static final Logger.ALogger LOG = Logger.of(IpcRequestor.class);
    private PostRequestPreparer postRequestPreparer;

    public IpcRequestor(Class<?> iface, AsyncTransceiver transceiver) throws IOException {
        super(iface, (Transceiver)transceiver);
    }

    public IpcRequestor(Class<?> iface, AsyncTransceiver transceiver, SpecificData data) throws IOException {
        super(iface, (Transceiver)transceiver, data);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        AsyncTransceiver transceiver = (AsyncTransceiver)this.getTransceiver();
        AsyncRequest asyncRequest = new AsyncRequest(method.getName(), args, new RPCContext());
        CallFuture callFuture = asyncRequest.getMessage().isOneWay() ? null : new CallFuture();
        Requestor.TransceiverCallback transceiverCallback = new Requestor.TransceiverCallback((Requestor)this, (Requestor.Request)asyncRequest, (Callback)callFuture);
        PostRequestPreparer postRequestPreparer = this.postRequestPreparer;
        if (postRequestPreparer == null) {
            try {
                postRequestPreparer = new AuthTokenPreservingPostRequestPreparer(Controller.request());
            }
            catch (RuntimeException e) {
                LOG.info("Unable to get current request; do not pass headers to downstream calls");
            }
        }
        if (F.Promise.class.isAssignableFrom(method.getReturnType())) {
            return transceiver.asyncTransceive(asyncRequest.getBytes(), postRequestPreparer).map(response -> {
                transceiverCallback.handleResult(response);
                if (callFuture == null) {
                    return null;
                }
                if (callFuture.getError() == null) {
                    return callFuture.getResult();
                }
                throw callFuture.getError();
            });
        }
        List<ByteBuffer> response2 = transceiver.transceive(asyncRequest.getBytes(), postRequestPreparer);
        transceiverCallback.handleResult(response2);
        if (callFuture == null) {
            return null;
        }
        if (callFuture.getError() == null) {
            return callFuture.getResult();
        }
        throw callFuture.getError();
    }

    public void setPostRequestPreparer(PostRequestPreparer postRequestPreparer) {
        this.postRequestPreparer = postRequestPreparer;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    class AsyncRequest
    extends Requestor.Request {
        public AsyncRequest(String messageName, Object request, RPCContext context) {
            super((Requestor)IpcRequestor.this, messageName, request, context);
        }
    }
}

