/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.specific.SpecificData;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Controller;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IpcRequestor
extends SpecificRequestor {
    public static final RequestHeadersSupplier DEFAULT_HEADERS_SUPPLIER = new RequestHeadersSupplier();
    public static final String[] DEFAULT_PRESERVED_HEADERS = new String[]{"Authorization"};
    private static final Logger.ALogger LOG = Logger.of(IpcRequestor.class);

    public IpcRequestor(Class<?> iface, AsyncTransceiver transceiver) throws IOException {
        super(iface, (Transceiver)transceiver);
    }

    public IpcRequestor(Class<?> iface, AsyncTransceiver transceiver, SpecificData data) throws IOException {
        super(iface, (Transceiver)transceiver, data);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        AsyncTransceiver transceiver = (AsyncTransceiver)this.getTransceiver();
        AsyncRequest asyncRequest = new AsyncRequest(method.getName(), args, new RPCContext());
        CallFuture callFuture = asyncRequest.getMessage().isOneWay() ? null : new CallFuture();
        Requestor.TransceiverCallback transceiverCallback = new Requestor.TransceiverCallback((Requestor)this, (Requestor.Request)asyncRequest, (Callback)callFuture);
        if (F.Promise.class.isAssignableFrom(method.getReturnType())) {
            return transceiver.asyncTransceive(asyncRequest.getBytes()).map(response -> {
                transceiverCallback.handleResult(response);
                if (callFuture == null) {
                    return null;
                }
                if (callFuture.getError() == null) {
                    return callFuture.getResult();
                }
                throw callFuture.getError();
            });
        }
        List<ByteBuffer> response2 = transceiver.transceive(asyncRequest.getBytes());
        transceiverCallback.handleResult(response2);
        if (callFuture == null) {
            return null;
        }
        if (callFuture.getError() == null) {
            return callFuture.getResult();
        }
        throw callFuture.getError();
    }

    public void setHeadersSupplier(Supplier<Map<String, String>> headersSupplier) {
        ((AsyncTransceiver)this.getTransceiver()).setHeadersSupplier(headersSupplier == null ? DEFAULT_HEADERS_SUPPLIER : headersSupplier);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    class AsyncRequest
    extends Requestor.Request {
        public AsyncRequest(String messageName, Object request, RPCContext context) {
            super((Requestor)IpcRequestor.this, messageName, request, context);
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class RequestHeadersSupplier
    implements Supplier<Map<String, String>> {
        @Override
        public Map<String, String> get() {
            Http.Request currentRequest = null;
            try {
                currentRequest = Controller.request();
            }
            catch (RuntimeException e) {
                LOG.info("Unable to get current request; do not pass headers to downstream calls");
            }
            if (currentRequest == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> headers = new HashMap<String, String>(DEFAULT_PRESERVED_HEADERS.length);
            for (String preservedHeader : DEFAULT_PRESERVED_HEADERS) {
                headers.put(preservedHeader, currentRequest.getHeader(preservedHeader));
            }
            return headers;
        }
    }
}

