/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import com.ning.http.client.AsyncHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.tfeng.play.plugins.AvroPlugin;
import me.tfeng.play.plugins.HttpPlugin;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.ipc.AsyncHttpException;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.HttpTransceiver;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.ws.WSResponse;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AsyncHttpTransceiver
extends HttpTransceiver
implements AsyncTransceiver {
    private Map<String, String> extraHeaders;
    private F.Promise<WSResponse> promise;
    private final Semaphore semaphore = new Semaphore(1);
    private int timeout = HttpPlugin.getInstance().getRequestTimeout();
    private final URL url;
    private Supplier<Map<String, String>> headersSupplier;

    public static List<ByteBuffer> readBuffers(InputStream in) throws IOException {
        return HttpTransceiver.readBuffers((InputStream)in);
    }

    public static void writeBuffers(List<ByteBuffer> buffers, OutputStream out) throws IOException {
        HttpTransceiver.writeBuffers(buffers, (OutputStream)out);
    }

    public AsyncHttpTransceiver(URL url) {
        super(url);
        this.url = url;
    }

    public F.Promise<List<ByteBuffer>> asyncReadBuffers() throws IOException {
        return this.promise.map(response -> {
            try {
                int status = response.getStatus();
                if (status >= 400) {
                    throw new AsyncHttpException(status, this.url);
                }
                InputStream stream = response.getBodyAsStream();
                return AsyncHttpTransceiver.readBuffers(stream);
            }
            catch (Throwable t) {
                throw new AvroRemoteException(t);
            }
        });
    }

    @Override
    public void setHeadersSupplier(Supplier<Map<String, String>> headersSupplier) {
        this.headersSupplier = headersSupplier;
    }

    @Override
    public F.Promise<List<ByteBuffer>> asyncTransceive(List<ByteBuffer> request) throws IOException {
        Map<String, String> extraHeaders = this.headersSupplier.get();
        return F.Promise.promise(() -> {
            this.semaphore.acquire();
            this.extraHeaders = extraHeaders;
            this.writeBuffers(request);
            return this;
        }, (ExecutionContext)AvroPlugin.getInstance().getIpcExecutionContext()).flatMap(transceiver -> {
            F.Promise<List<ByteBuffer>> promise = transceiver.asyncReadBuffers();
            promise.onFailure(throwable -> {
                this.extraHeaders = null;
                asyncHttpTransceiver.semaphore.release();
            });
            promise.onRedeem(response -> {
                this.extraHeaders = null;
                asyncHttpTransceiver.semaphore.release();
            });
            return promise;
        });
    }

    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        return (List)this.asyncReadBuffers().get((long)this.timeout);
    }

    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        this.timeout = timeout;
    }

    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AsyncHttpTransceiver.writeBuffers(buffers, outputStream);
        this.promise = this.postRequest(this.url, outputStream.toByteArray());
    }

    protected String getContentType() {
        return "avro/binary";
    }

    protected Consumer<AsyncHttpClient.BoundRequestBuilder> getRequestPreparer(URL url, byte[] body, Map<String, String> extraHeaders) {
        return builder -> {
            if (extraHeaders != null) {
                extraHeaders.forEach((key, value) -> builder.setHeader(key, value));
            }
        };
    }

    protected F.Promise<WSResponse> postRequest(URL url, byte[] body) throws IOException {
        return HttpPlugin.getInstance().postRequest(url, this.getContentType(), body, this.getRequestPreparer(url, body, this.extraHeaders));
    }
}

