/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import me.tfeng.play.plugins.AbstractPlugin;
import org.apache.avro.ipc.AsyncHttpTransceiver;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.IpcRequestor;
import org.apache.avro.specific.SpecificData;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import play.Application;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroPlugin
extends AbstractPlugin {
    private ExecutionContext ipcExecutionContext;
    @Value(value="${avro-plugin.ipc-execution-context:play.akka.actor.default-dispatcher}")
    private String ipcExecutionContextId;
    private Map<Class<?>, Object> protocolImplementations;

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver) {
        return AvroPlugin.client(interfaceClass, transceiver, new SpecificData(interfaceClass.getClassLoader()));
    }

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver, SpecificData data) {
        return AvroPlugin.client(interfaceClass, transceiver, data, null);
    }

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver, SpecificData data, Supplier<Map<String, String>> headersSupplier) {
        try {
            IpcRequestor requestor = new IpcRequestor(interfaceClass, transceiver, data);
            requestor.setHeadersSupplier(headersSupplier);
            return (T)Proxy.newProxyInstance(data.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)((Object)requestor));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create async client", e);
        }
    }

    public static <T> T client(Class<T> interfaceClass, AsyncTransceiver transceiver, Supplier<Map<String, String>> headersSupplier) {
        return AvroPlugin.client(interfaceClass, transceiver, new SpecificData(interfaceClass.getClassLoader()), headersSupplier);
    }

    public static <T> T client(Class<T> interfaceClass, URL url) {
        return AvroPlugin.client(interfaceClass, new AsyncHttpTransceiver(url));
    }

    public static <T> T client(Class<T> interfaceClass, URL url, SpecificData data) {
        return AvroPlugin.client(interfaceClass, (AsyncTransceiver)new AsyncHttpTransceiver(url), data);
    }

    public static <T> T client(Class<T> interfaceClass, URL url, SpecificData data, Supplier<Map<String, String>> headersSupplier) {
        return AvroPlugin.client(interfaceClass, new AsyncHttpTransceiver(url), data, headersSupplier);
    }

    public static <T> T client(Class<T> interfaceClass, URL url, Supplier<Map<String, String>> headersSupplier) {
        return AvroPlugin.client(interfaceClass, (AsyncTransceiver)new AsyncHttpTransceiver(url), headersSupplier);
    }

    public static AvroPlugin getInstance() {
        return (AvroPlugin)((Object)Play.application().plugin(AvroPlugin.class));
    }

    public AvroPlugin(Application application) {
        super(application);
    }

    public ExecutionContext getIpcExecutionContext() {
        return this.ipcExecutionContext;
    }

    public Map<Class<?>, Object> getProtocolImplementations() {
        return this.protocolImplementations;
    }

    public void onStart() {
        super.onStart();
        this.ipcExecutionContext = Akka.system().dispatchers().lookup(this.ipcExecutionContextId);
        try {
            this.protocolImplementations = (Map)this.getApplicationContext().getBean("avro-plugin.protocol-implementations", Map.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.protocolImplementations = Collections.emptyMap();
        }
    }
}

