/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.factories;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import play.libs.F;
import scala.concurrent.ExecutionContext;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroLocalClientFactory
implements FactoryBean<Object>,
InvocationHandler {
    private static final Logger.ALogger LOG = Logger.of(AvroLocalClientFactory.class);
    private Object bean;
    private ExecutionContext executionContext;
    private Class<?> interfaceClass;

    public Object getObject() throws Exception {
        return Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)this);
    }

    public Class<?> getObjectType() {
        return this.interfaceClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method beanMethod = this.bean.getClass().getMethod(method.getName(), method.getParameterTypes());
        if (this.executionContext == null) {
            return F.Promise.promise(() -> {
                try {
                    return beanMethod.invoke(this.bean, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        return F.Promise.promise(() -> {
            try {
                return beanMethod.invoke(this.bean, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }, (ExecutionContext)this.executionContext);
    }

    public boolean isSingleton() {
        return false;
    }

    @Required
    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setExecutionContextId(String executionContextId) {
        try {
            this.executionContext = Akka.system().dispatchers().lookup(executionContextId);
        }
        catch (Exception e) {
            LOG.warn("Unable to get Akka execution context " + executionContextId + "; using default");
        }
    }

    @Required
    public void setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }
}

