/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.factories;

import java.net.URL;
import me.tfeng.play.plugins.AvroPlugin;
import org.apache.avro.specific.SpecificData;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroIpcClientFactory
implements FactoryBean<Object> {
    private Class<?> interfaceClass;
    private SpecificData specificData;
    private URL url;

    public Object getObject() throws Exception {
        SpecificData specificData = this.specificData;
        if (specificData == null) {
            specificData = new SpecificData(this.interfaceClass.getClassLoader());
        }
        return AvroPlugin.client(this.interfaceClass, this.url, specificData);
    }

    public Class<?> getObjectType() {
        return this.interfaceClass;
    }

    public boolean isSingleton() {
        return false;
    }

    @Required
    public void setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public void setSpecificData(SpecificData specificData) {
        this.specificData = specificData;
    }

    @Required
    public void setUrl(URL url) {
        this.url = url;
    }
}

