/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.AsyncHttpTransceiver;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.specific.SpecificData;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IpcRequestor
extends SpecificRequestor {
    private SpecificRequestor syncRequestor;
    private final URL url;

    public IpcRequestor(Class<?> iface, URL url) throws IOException {
        super(iface, (Transceiver)new AsyncHttpTransceiver(url));
        this.url = url;
    }

    public IpcRequestor(Class<?> iface, URL url, SpecificData data) throws IOException {
        super(iface, (Transceiver)new AsyncHttpTransceiver(url), data);
        this.url = url;
    }

    public IpcRequestor(Protocol protocol, URL url) throws IOException {
        super(protocol, (Transceiver)new AsyncHttpTransceiver(url));
        this.url = url;
    }

    public IpcRequestor(Protocol protocol, URL url, SpecificData data) throws IOException {
        super(protocol, (Transceiver)new AsyncHttpTransceiver(url), data);
        this.url = url;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (F.Promise.class.isAssignableFrom(method.getReturnType())) {
            AsyncRequest asyncRequest = new AsyncRequest(method.getName(), args, new RPCContext());
            AsyncHttpTransceiver transceiver = (AsyncHttpTransceiver)this.getTransceiver();
            CallFuture callFuture = asyncRequest.getMessage().isOneWay() ? null : new CallFuture();
            Requestor.TransceiverCallback transceiverCallback = new Requestor.TransceiverCallback((Requestor)this, (Requestor.Request)asyncRequest, (Callback)callFuture);
            return transceiver.asyncTransceive(asyncRequest.getBytes()).map(response -> {
                transceiverCallback.handleResult(response);
                if (callFuture == null) {
                    return null;
                }
                if (callFuture.getError() == null) {
                    return callFuture.getResult();
                }
                throw callFuture.getError();
            });
        }
        if (this.syncRequestor == null) {
            this.syncRequestor = new SpecificRequestor(this.getLocal(), (Transceiver)new HttpTransceiver(this.url), this.getSpecificData());
        }
        return this.syncRequestor.invoke(proxy, method, args);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    class AsyncRequest
    extends Requestor.Request {
        public AsyncRequest(String messageName, Object request, RPCContext context) {
            super((Requestor)IpcRequestor.this, messageName, request, context);
        }
    }
}

