/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import org.apache.avro.ipc.HttpTransceiver;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class InternalHttpTransceiver
extends HttpTransceiver {
    private Consumer<HttpURLConnection> defaultConnectionPrepairer;
    private Proxy proxy;
    private int timeout;
    private URL url;
    protected HttpURLConnection connection;

    public static List<ByteBuffer> readBuffers(InputStream in) throws IOException {
        return HttpTransceiver.readBuffers((InputStream)in);
    }

    public static void writeBuffers(List<ByteBuffer> buffers, OutputStream out) throws IOException {
        HttpTransceiver.writeBuffers(buffers, (OutputStream)out);
    }

    public InternalHttpTransceiver(URL url) {
        super(url);
        this.url = url;
    }

    public InternalHttpTransceiver(URL url, Consumer<HttpURLConnection> defaultConnectionPrepairer) {
        this(url);
        this.defaultConnectionPrepairer = defaultConnectionPrepairer;
    }

    public InternalHttpTransceiver(URL url, Proxy proxy) {
        super(url, proxy);
        this.url = url;
        this.proxy = proxy;
    }

    public InternalHttpTransceiver(URL url, Proxy proxy, Consumer<HttpURLConnection> defaultConnectionPrepairer) {
        this(url, proxy);
        this.defaultConnectionPrepairer = defaultConnectionPrepairer;
    }

    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        try (InputStream in = this.connection.getInputStream();){
            List<ByteBuffer> list = InternalHttpTransceiver.readBuffers(in);
            return list;
        }
    }

    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        this.timeout = timeout;
    }

    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        this.writeBuffers(buffers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeBuffers(List<ByteBuffer> buffers, Consumer<HttpURLConnection> connectionPrepairer) throws IOException {
        this.connection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", "avro/binary");
        this.connection.setRequestProperty("Content-Length", Integer.toString(InternalHttpTransceiver.getLength(buffers)));
        this.connection.setDoOutput(true);
        this.connection.setReadTimeout(this.timeout);
        this.connection.setConnectTimeout(this.timeout);
        if (connectionPrepairer != null) {
            connectionPrepairer.accept(this.connection);
        }
        if (this.defaultConnectionPrepairer != null) {
            this.defaultConnectionPrepairer.accept(this.connection);
        }
        try (OutputStream out = this.connection.getOutputStream();){
            InternalHttpTransceiver.writeBuffers(buffers, out);
        }
    }
}

