/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import me.tfeng.play.plugins.HttpPlugin;
import org.apache.avro.ipc.HttpTransceiver;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AsyncHttpTransceiver
extends HttpTransceiver {
    private F.Promise<WSResponse> promise;
    private int timeout;
    private final URL url;

    public AsyncHttpTransceiver(URL url) {
        super(url);
        this.url = url;
    }

    public F.Promise<List<ByteBuffer>> asyncReadBuffers() throws IOException {
        return this.promise.map(response -> {
            InputStream stream = response.getBodyAsStream();
            return AsyncHttpTransceiver.readBuffers((InputStream)stream);
        });
    }

    public F.Promise<List<ByteBuffer>> asyncTransceive(List<ByteBuffer> request) throws IOException {
        this.lockChannel();
        this.writeBuffers(request);
        return this.asyncReadBuffers().transform(response -> {
            this.unlockChannel();
            return response;
        }, throwable -> {
            this.unlockChannel();
            return throwable;
        });
    }

    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        return (List)this.asyncReadBuffers().get((long)this.timeout);
    }

    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        this.timeout = timeout;
    }

    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AsyncHttpTransceiver.writeBuffers(buffers, (OutputStream)outputStream);
        this.promise = HttpPlugin.getInstance().postRequest(this.url, "avro/binary", outputStream.toByteArray());
    }
}

