/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Map;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.plugins.AbstractPlugin;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.IpcRequestor;
import org.apache.avro.specific.SpecificData;
import play.Application;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroPlugin
extends AbstractPlugin {
    private Map<Class<?>, Object> protocolImplementations;

    public static AvroPlugin getInstance() {
        return (AvroPlugin)((Object)Play.application().plugin(AvroPlugin.class));
    }

    public AvroPlugin(Application application) {
        super(application);
    }

    public <T> T client(Class<T> interfaceClass, URL url) {
        return this.client(interfaceClass, url, new SpecificData(interfaceClass.getClassLoader()));
    }

    public <T> T client(Class<T> interfaceClass, URL url, SpecificData data) {
        try {
            Protocol protocol = AvroHelper.getProtocol(interfaceClass);
            return (T)Proxy.newProxyInstance(data.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)((Object)new IpcRequestor(protocol, url, data)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create async client", e);
        }
    }

    public Map<Class<?>, Object> getProtocolImplementations() {
        return this.protocolImplementations;
    }

    public void onStart() {
        super.onStart();
        this.protocolImplementations = (Map)this.getApplicationContext().getBean("avro-plugin.protocol-implementations", Map.class);
    }
}

