/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.plugins.AvroPlugin;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.http.entity.ContentType;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JsonIpcController
extends Controller {
    public static final String CONTENT_TYPE = "avro/json";
    private static final Transceiver EMPTY_TRANSCEIVER = new EmptyTransceiver();
    private static final SpecificDatumReader<HandshakeResponse> HANDSHAKE_READER = new SpecificDatumReader(HandshakeResponse.class);
    private static final Constructor<?> REQUEST_CONSTRUCTOR;
    private static final Method REQUEST_GETBYTES_METHOD;
    private static final Constructor<?> RESPONSE_CONSTRUCTOR;
    private static final Method RESPONSE_GETRESPONSE_METHOD;

    @BodyParser.Of(value=BodyParser.Raw.class)
    public static Result post(String message, String protocol) throws Throwable {
        String contentTypeHeader = JsonIpcController.request().getHeader("content-type");
        ContentType contentType = ContentType.parse((String)contentTypeHeader);
        if (!CONTENT_TYPE.equals(contentType.getMimeType())) {
            throw new RuntimeException("Unable to handle content-type " + contentType + "; " + CONTENT_TYPE + " is expected");
        }
        AvroPlugin plugin = AvroPlugin.getInstance();
        Class<?> protocolClass = Play.application().classloader().loadClass(protocol);
        Object implementation = plugin.getProtocolImplementations().get(protocolClass);
        Protocol avroProtocol = AvroHelper.getProtocol(protocolClass);
        GenericRequestor requestor = new GenericRequestor(avroProtocol, EMPTY_TRANSCEIVER);
        byte[] bytes = JsonIpcController.request().body().asRaw().asBytes();
        Object request = JsonIpcController.getRequest((Requestor)requestor, avroProtocol, message, bytes);
        List<ByteBuffer> buffers = JsonIpcController.convertToBuffers(request);
        SpecificResponder responder = new SpecificResponder(protocolClass, implementation);
        List responseBuffers = responder.respond(buffers);
        try {
            Object response = JsonIpcController.getResponse((Requestor)requestor, request, responseBuffers);
            return Results.ok((String)AvroHelper.toJson(((Protocol.Message)avroProtocol.getMessages().get(message)).getResponse(), response));
        }
        catch (AvroRemoteException e) {
            Schema schema = ((Protocol.Message)avroProtocol.getMessages().get(message)).getErrors();
            return Results.badRequest((String)AvroHelper.toJson(schema, e.getValue()));
        }
    }

    private static List<ByteBuffer> convertToBuffers(Object requestObject) throws Throwable {
        try {
            return (List)REQUEST_GETBYTES_METHOD.invoke(requestObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static JsonNode enhanceWithDefaultFields(Schema schema, JsonNode json, JsonNodeFactory factory) {
        if (json instanceof ObjectNode && schema.getType() == Schema.Type.RECORD) {
            ObjectNode node = (ObjectNode)json;
            ObjectNode newNode = factory.objectNode();
            for (Schema.Field field : schema.getFields()) {
                String fieldName = field.name();
                if (node.has(fieldName)) {
                    newNode.put(fieldName, JsonIpcController.enhanceWithDefaultFields(field.schema(), node.get(fieldName), factory));
                    continue;
                }
                if (field.defaultValue() != null) {
                    newNode.put(fieldName, Json.parse((String)field.defaultValue().toString()));
                    continue;
                }
                newNode.put(fieldName, (JsonNode)factory.nullNode());
            }
            return newNode;
        }
        if (json instanceof ArrayNode && schema.getType() == Schema.Type.ARRAY) {
            ArrayNode node = (ArrayNode)json;
            ArrayNode newNode = factory.arrayNode();
            Iterator iterator = node.elements();
            while (iterator.hasNext()) {
                newNode.add(JsonIpcController.enhanceWithDefaultFields(schema.getElementType(), (JsonNode)iterator.next(), factory));
            }
            return newNode;
        }
        return json;
    }

    private static Object getRequest(Requestor requestor, Protocol protocol, String message, byte[] data) throws Throwable {
        Protocol.Message messageObject = (Protocol.Message)protocol.getMessages().get(message);
        if (messageObject == null) {
            throw new AvroRuntimeException("No message named " + message + " in " + protocol);
        }
        Schema schema = messageObject.getRequest();
        JsonNode node = Json.parse((InputStream)new ByteArrayInputStream(data));
        node = JsonIpcController.enhanceWithDefaultFields(schema, node, new JsonNodeFactory(false));
        GenericDatumReader reader = new GenericDatumReader(schema);
        Object request = reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, node.toString()));
        try {
            return REQUEST_CONSTRUCTOR.newInstance(requestor, message, request, new RPCContext());
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object getResponse(Requestor requestor, Object request, List<ByteBuffer> buffers) throws Throwable {
        ByteBufferInputStream bbi = new ByteBufferInputStream(buffers);
        BinaryDecoder in = DecoderFactory.get().binaryDecoder((InputStream)bbi, null);
        HANDSHAKE_READER.read(null, (Decoder)in);
        Object responseObject = RESPONSE_CONSTRUCTOR.newInstance(requestor, request, in);
        try {
            return RESPONSE_GETRESPONSE_METHOD.invoke(responseObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        try {
            Class<?> requestClass = Requestor.class.getClassLoader().loadClass("org.apache.avro.ipc.Requestor$Request");
            Class<?> responseClass = Requestor.class.getClassLoader().loadClass("org.apache.avro.ipc.Requestor$Response");
            Constructor<?> requestConstructor = requestClass.getConstructor(Requestor.class, String.class, Object.class, RPCContext.class);
            requestConstructor.setAccessible(true);
            Constructor<?> responseConstructor = responseClass.getConstructor(Requestor.class, requestClass, BinaryDecoder.class);
            responseConstructor.setAccessible(true);
            Method requestGetBytesMethod = requestClass.getMethod("getBytes", new Class[0]);
            requestGetBytesMethod.setAccessible(true);
            Method responseGetResponseMethod = responseClass.getMethod("getResponse", new Class[0]);
            responseGetResponseMethod.setAccessible(true);
            REQUEST_CONSTRUCTOR = requestConstructor;
            RESPONSE_CONSTRUCTOR = responseConstructor;
            REQUEST_GETBYTES_METHOD = requestGetBytesMethod;
            RESPONSE_GETRESPONSE_METHOD = responseGetResponseMethod;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class EmptyTransceiver
    extends Transceiver {
        private EmptyTransceiver() {
        }

        public String getRemoteName() throws IOException {
            return "localhost";
        }

        public List<ByteBuffer> readBuffers() throws IOException {
            return Collections.emptyList();
        }

        public void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        }
    }
}

