/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroHelper {
    public static Protocol getProtocol(Class<?> interfaceClass) {
        return new SpecificData(interfaceClass.getClassLoader()).getProtocol(interfaceClass);
    }

    public static Schema getSchema(Class<?> schemaClass) {
        return new SpecificData(schemaClass.getClassLoader()).getSchema(schemaClass);
    }

    public static String toJson(Schema schema, Object object) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        JsonGenerator generator = new JsonFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
        generator.useDefaultPrettyPrinter();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, generator);
        writer.write(object, (Encoder)encoder);
        encoder.flush();
        return outputStream.toString();
    }

    public static <T> T toRecord(Class<T> recordClass, String json) throws IOException {
        SpecificDatumReader reader = new SpecificDatumReader(recordClass);
        return (T)reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(AvroHelper.getSchema(recordClass), json));
    }

    public static <T> T toRecord(Schema schema, String json) throws IOException {
        SpecificDatumReader reader = new SpecificDatumReader(schema);
        return (T)reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, json));
    }
}

