/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.avro.d2.AvroD2Client;
import me.tfeng.play.avro.d2.AvroD2Server;
import me.tfeng.play.http.PostRequestPreparer;
import me.tfeng.play.plugins.AbstractPlugin;
import org.apache.avro.Protocol;
import org.apache.avro.specific.SpecificData;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import play.Application;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Plugin
extends AbstractPlugin
implements Watcher {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Plugin.class);
    @Value(value="${avro-d2-plugin.client-refresh-retry-delay-ms:1000}")
    private long clientRefreshRetryDelay;
    private boolean expired;
    private Map<Class<?>, String> protocolPaths;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Value(value="${avro-d2-plugin.server-host}")
    private String serverHost;
    @Value(value="${avro-d2-plugin.server-port}")
    private int serverPort;
    @Value(value="${avro-d2-plugin.server-register-retry-delay-ms:1000}")
    private long serverRegisterRetryDelay;
    private List<AvroD2Server> servers;
    private ZooKeeper zk;
    @Value(value="${avro-d2-plugin.zk-connect-string}")
    private String zkConnectString;
    @Value(value="${avro-d2-plugin.zk-session-timeout:10000}")
    private int zkSessionTimeout;

    public static <T> T client(Class<T> interfaceClass) {
        return AvroD2Plugin.client(interfaceClass, new SpecificData(interfaceClass.getClassLoader()));
    }

    public static <T> T client(Class<T> interfaceClass, PostRequestPreparer postRequestPreparer) {
        return AvroD2Plugin.client(interfaceClass, new SpecificData(interfaceClass.getClassLoader()), postRequestPreparer);
    }

    public static <T> T client(Class<T> interfaceClass, SpecificData data) {
        return AvroD2Plugin.client(interfaceClass, data, null);
    }

    public static <T> T client(Class<T> interfaceClass, SpecificData data, PostRequestPreparer postRequestPreparer) {
        AvroD2Client client = new AvroD2Client(interfaceClass, data);
        client.setPostRequestPreparer(postRequestPreparer);
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)client));
    }

    public static AvroD2Plugin getInstance() {
        return (AvroD2Plugin)((Object)Play.application().plugin(AvroD2Plugin.class));
    }

    public AvroD2Plugin(Application application) {
        super(application);
    }

    public void connect() {
        try {
            this.zk = new ZooKeeper(this.zkConnectString, this.zkSessionTimeout, (Watcher)this);
        }
        catch (IOException e) {
            this.getScheduler().schedule(() -> this.connect(), this.getClientRefreshRetryDelay(), TimeUnit.MILLISECONDS);
            LOG.warn("Unable to connect to ZooKeeper; retry later", (Throwable)e);
        }
    }

    public long getClientRefreshRetryDelay() {
        return this.clientRefreshRetryDelay;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public long getServerRegisterRetryDelay() {
        return this.serverRegisterRetryDelay;
    }

    public ZooKeeper getZooKeeper() {
        return this.zk;
    }

    public void onStart() {
        super.onStart();
        try {
            this.protocolPaths = (Map)this.getApplicationContext().getBean("avro-d2-plugin.protocol-paths", Map.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.protocolPaths = Collections.emptyMap();
        }
        this.connect();
        this.startServers();
    }

    public void onStop() {
        this.stopServers();
    }

    public void process(WatchedEvent event) {
        LOG.info(event.toString());
        switch (event.getState()) {
            case SyncConnected: {
                if (!this.expired) break;
                this.expired = false;
                this.servers.forEach(server -> server.register());
                break;
            }
            case Expired: {
                this.expired = true;
                try {
                    this.zk.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connect();
            }
        }
    }

    public void startServers() {
        this.servers = new ArrayList<AvroD2Server>(this.protocolPaths.size());
        for (Map.Entry<Class<?>, String> entry : this.protocolPaths.entrySet()) {
            URL url;
            Protocol protocol = AvroHelper.getProtocol(entry.getKey());
            String path = entry.getValue();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            try {
                url = new URL("http", this.serverHost, this.serverPort, path);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize server", e);
            }
            AvroD2Server server = new AvroD2Server(protocol, url);
            this.servers.add(server);
        }
    }

    public void stopServers() {
        this.servers.stream().forEach(server -> {
            try {
                server.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close server for " + server.getProtocol().getName() + " at " + server.getUrl() + "; ignoring");
            }
        });
        this.servers.clear();
    }
}

