/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.avro.d2.AvroD2Client;
import me.tfeng.play.avro.d2.AvroD2Server;
import me.tfeng.play.http.PostRequestPreparer;
import me.tfeng.play.plugins.AbstractPlugin;
import org.apache.avro.Protocol;
import org.apache.avro.specific.SpecificData;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import play.Application;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Plugin
extends AbstractPlugin
implements Watcher {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Plugin.class);
    @Value(value="${avro-d2-plugin.client-refresh-retry-delay-ms:1000}")
    private long clientRefreshRetryDelay;
    private Map<Class<?>, String> protocolPaths;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Value(value="${avro-d2-plugin.server-host}")
    private String serverHost;
    @Value(value="${avro-d2-plugin.server-port}")
    private int serverPort;
    @Value(value="${avro-d2-plugin.server-register-retry-delay-ms:1000}")
    private long serverRegisterRetryDelay;
    private List<AvroD2Server> servers;
    private ZooKeeper zk;
    @Value(value="${avro-d2-plugin.zk-connect-string}")
    private String zkConnectString;
    @Value(value="${avro-d2-plugin.zk-session-timeout:10000}")
    private int zkSessionTimeout;

    public static <T> T client(Class<T> interfaceClass) {
        return AvroD2Plugin.client(interfaceClass, new SpecificData(interfaceClass.getClassLoader()));
    }

    public static <T> T client(Class<T> interfaceClass, PostRequestPreparer postRequestPreparer) {
        return AvroD2Plugin.client(interfaceClass, new SpecificData(interfaceClass.getClassLoader()), postRequestPreparer);
    }

    public static <T> T client(Class<T> interfaceClass, SpecificData data) {
        return AvroD2Plugin.client(interfaceClass, data, null);
    }

    public static <T> T client(Class<T> interfaceClass, SpecificData data, PostRequestPreparer postRequestPreparer) {
        AvroD2Client client = new AvroD2Client(interfaceClass, data);
        client.setPostRequestPreparer(postRequestPreparer);
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)client));
    }

    public static AvroD2Plugin getInstance() {
        return (AvroD2Plugin)((Object)Play.application().plugin(AvroD2Plugin.class));
    }

    public AvroD2Plugin(Application application) {
        super(application);
    }

    public long getClientRefreshRetryDelay() {
        return this.clientRefreshRetryDelay;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public long getServerRegisterRetryDelay() {
        return this.serverRegisterRetryDelay;
    }

    public ZooKeeper getZooKeeper() {
        return this.zk;
    }

    public void onStart() {
        super.onStart();
        try {
            this.protocolPaths = (Map)this.getApplicationContext().getBean("avro-d2-plugin.protocol-paths", Map.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.protocolPaths = Collections.emptyMap();
        }
        try {
            this.zk = new ZooKeeper(this.zkConnectString, this.zkSessionTimeout, (Watcher)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to connect to ZooKeeper", e);
        }
        this.startServers();
    }

    public void onStop() {
        this.stopServers();
    }

    public void process(WatchedEvent event) {
        LOG.info(event.toString());
    }

    public void startServers() {
        try {
            this.servers = new ArrayList<AvroD2Server>(this.protocolPaths.size());
            for (Map.Entry<Class<?>, String> entry : this.protocolPaths.entrySet()) {
                Protocol protocol = AvroHelper.getProtocol(entry.getKey());
                String path = entry.getValue();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                URL url = new URL("http", this.serverHost, this.serverPort, path);
                AvroD2Server server = new AvroD2Server(this.zk, protocol, url);
                this.servers.add(server);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize server", e);
        }
    }

    public void stopServers() {
        this.servers.stream().forEach(server -> {
            try {
                server.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close server for " + server.getProtocol().getName() + " at " + server.getUrl() + "; ignoring");
            }
        });
        this.servers.clear();
    }
}

