/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro.d2;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import me.tfeng.play.avro.d2.AvroD2Helper;
import me.tfeng.play.plugins.AvroD2Plugin;
import org.apache.avro.Protocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Server
implements Watcher {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Server.class);
    protected volatile String nodePath;
    protected final Protocol protocol;
    protected final URL url;
    protected final ZooKeeper zk;

    public AvroD2Server(ZooKeeper zk, Protocol protocol, URL url) {
        this.zk = zk;
        this.protocol = protocol;
        this.url = url;
        this.register();
    }

    public synchronized void close() throws InterruptedException, KeeperException {
        String path = this.nodePath;
        if (path != null) {
            LOG.info("Closing server for " + this.protocol.getName() + " at " + this.url);
            try {
                this.zk.delete(path, -1);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            this.nodePath = null;
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URL getUrl() {
        return this.url;
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(this.nodePath) || event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.register();
        }
    }

    public synchronized void register() {
        try {
            this.close();
            LOG.info("Registering server for " + this.protocol.getName() + " at " + this.url);
            this.nodePath = AvroD2Helper.createProtocolNode(this.zk, this.protocol, this.url);
            this.zk.getData(this.nodePath, (Watcher)this, null);
        }
        catch (Exception e) {
            LOG.warn("Unable to register server for " + this.protocol.getName() + "; retry later", (Throwable)e);
            AvroD2Plugin.getInstance().getScheduler().schedule(() -> this.register(), AvroD2Plugin.getInstance().getServerRegisterRetryDelay(), TimeUnit.MILLISECONDS);
        }
    }
}

