/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro.d2;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Helper {
    public static final String SCHEME = "avsd";
    public static final Charset UTF8 = Charset.forName("utf8");

    public static String createProtocolNode(ZooKeeper zk, Protocol protocol, URL serverUrl) throws KeeperException, InterruptedException {
        AvroD2Helper.ensurePath(zk, AvroD2Helper.getZkPath(protocol));
        return zk.create(AvroD2Helper.getZkPath(protocol) + "/", serverUrl.toString().getBytes(), (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public static void ensurePath(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        String part;
        int index = path.lastIndexOf("/");
        if (index > 0) {
            AvroD2Helper.ensurePath(zk, path.substring(0, index));
        }
        if (!(part = path.substring(index + 1)).isEmpty()) {
            try {
                zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                // empty catch block
            }
        }
    }

    public static URI getUri(Protocol protocol) {
        try {
            return new URI("avsd:/" + AvroD2Helper.getZkPath(protocol));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getZkPath(Protocol protocol) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(protocol.getMD5());
            String md5 = new BigInteger(1, digest.digest()).toString(16);
            return "/" + protocol.getName() + "/" + md5;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

