/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro.d2;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.avro.d2.AvroD2Helper;
import me.tfeng.play.avro.d2.AvroD2Transceiver;
import me.tfeng.play.plugins.AvroD2Plugin;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.AsyncTransceiver;
import org.apache.avro.ipc.IpcRequestor;
import org.apache.avro.specific.SpecificData;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Client
implements Watcher,
InvocationHandler {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Client.class);
    private final SpecificData data;
    private Supplier<Map<String, String>> headersSupplier;
    private final Class<?> interfaceClass;
    private int lastIndex = -1;
    private final Protocol protocol;
    private IpcRequestor requestor;
    private final List<URL> serverUrls = new ArrayList<URL>();

    public AvroD2Client(Class<?> interfaceClass) {
        this(interfaceClass, new SpecificData(interfaceClass.getClassLoader()));
    }

    public AvroD2Client(Class<?> interfaceClass, SpecificData data) {
        this.interfaceClass = interfaceClass;
        this.data = data;
        this.protocol = AvroHelper.getProtocol(interfaceClass);
    }

    public URL getNextServerUrl() {
        if (this.serverUrls.isEmpty()) {
            throw new RuntimeException("No server is found for " + AvroD2Helper.getUri(this.protocol));
        }
        this.lastIndex = (this.lastIndex + 1) % this.serverUrls.size();
        return this.serverUrls.get(this.lastIndex);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.requestor == null) {
            this.refresh();
            try {
                this.requestor = new IpcRequestor(this.interfaceClass, (AsyncTransceiver)new AvroD2Transceiver(this), this.data);
                this.requestor.setHeadersSupplier(this.headersSupplier);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to initialize Avro requestor for " + this.protocol.getName(), e);
            }
        }
        return this.requestor.invoke(proxy, method, args);
    }

    public void process(WatchedEvent event) {
        this.refresh();
    }

    public void refresh() {
        List children;
        String path = AvroD2Helper.getZkPath(this.protocol);
        ZooKeeper zk = AvroD2Plugin.getInstance().getZooKeeper();
        try {
            children = zk.getChildren(path, (Watcher)this);
        }
        catch (Exception e) {
            LOG.warn("Unable to list servers for " + this.protocol.getName() + "; retry later", (Throwable)e);
            this.scheduleRefresh();
            return;
        }
        this.serverUrls.clear();
        for (String child : children) {
            String childPath = path + "/" + child;
            try {
                byte[] data = zk.getData(childPath, false, null);
                String serverUrl = new String(data, Charset.forName("utf8"));
                this.serverUrls.add(new URL(serverUrl));
            }
            catch (Exception e) {
                LOG.warn("Unable to get server URL from node " + childPath, (Throwable)e);
            }
        }
        if (this.serverUrls.isEmpty()) {
            LOG.warn("Unable to get any server URL for protocol " + this.protocol.getName() + "; retry later");
            this.scheduleRefresh();
        }
    }

    public void setHeadersSupplier(Supplier<Map<String, String>> headersSupplier) {
        this.headersSupplier = headersSupplier;
        if (this.requestor != null) {
            this.requestor.setHeadersSupplier(headersSupplier);
        }
    }

    private void scheduleRefresh() {
        AvroD2Plugin.getInstance().getScheduler().schedule(() -> this.refresh(), AvroD2Plugin.getInstance().getClientRefreshRetryDelay(), TimeUnit.MILLISECONDS);
    }
}

