/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro.d2;

import java.net.URL;
import me.tfeng.play.avro.d2.AvroD2Helper;
import org.apache.avro.Protocol;
import org.apache.zookeeper.ZooKeeper;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Server {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Server.class);
    protected String nodePath;
    protected final Protocol protocol;
    protected final URL serverUrl;
    protected final ZooKeeper zk;

    public AvroD2Server(ZooKeeper zk, Protocol protocol, URL serverUrl) {
        this.zk = zk;
        this.protocol = protocol;
        this.serverUrl = serverUrl;
        this.register();
    }

    public void close() {
        try {
            if (this.nodePath != null) {
                LOG.info("Closing server " + this.serverUrl);
                this.zk.delete(this.nodePath, -1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close server at " + AvroD2Helper.getUri(this.protocol), e);
        }
    }

    public void register() {
        this.close();
        LOG.info("Registering server for " + AvroD2Helper.getUri(this.protocol) + " at " + this.serverUrl);
        try {
            this.nodePath = AvroD2Helper.createProtocolNode(this.zk, this.protocol, this.serverUrl);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register server at " + AvroD2Helper.getUri(this.protocol), e);
        }
    }
}

