/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro.d2;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.avro.d2.AvroD2Helper;
import me.tfeng.play.avro.d2.AvroD2Transceiver;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Client
implements Watcher,
InvocationHandler {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Client.class);
    private int lastIndex = -1;
    private final Protocol protocol;
    private final SpecificRequestor requestor;
    private final List<URL> serverUrls = new ArrayList<URL>();
    private final ZooKeeper zk;

    public AvroD2Client(ZooKeeper zk, Class<?> interfaceClass) {
        this.zk = zk;
        this.protocol = AvroHelper.getProtocol(interfaceClass);
        this.refresh();
        try {
            this.requestor = new SpecificRequestor(interfaceClass, (Transceiver)new AvroD2Transceiver(this));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize Avro requestor for " + AvroD2Helper.getUri(this.protocol), e);
        }
    }

    public URL getNextServerUrl() {
        if (this.serverUrls.isEmpty()) {
            throw new RuntimeException("No server is found for " + AvroD2Helper.getUri(this.protocol));
        }
        this.lastIndex = (this.lastIndex + 1) % this.serverUrls.size();
        return this.serverUrls.get(this.lastIndex);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.requestor.invoke(proxy, method, args);
    }

    public void process(WatchedEvent event) {
        try {
            this.refresh();
        }
        catch (Exception e) {
            LOG.error("Unable to get server URL from path " + AvroD2Helper.getZkPath(this.protocol));
        }
    }

    public void refresh() {
        List children;
        String path = AvroD2Helper.getZkPath(this.protocol);
        try {
            children = this.zk.getChildren(path, (Watcher)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to list servers for " + AvroD2Helper.getUri(this.protocol));
        }
        this.serverUrls.clear();
        for (String child : children) {
            String childPath = path + "/" + child;
            try {
                byte[] data = this.zk.getData(childPath, false, null);
                String serverUrl = new String(data, Charset.forName("utf8"));
                this.serverUrls.add(new URL(serverUrl));
            }
            catch (Exception e) {
                LOG.warn("Unable to get server URL from node " + childPath);
            }
        }
    }
}

