/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.tfeng.play.avro.AvroHelper;
import me.tfeng.play.avro.d2.AvroD2Client;
import me.tfeng.play.avro.d2.AvroD2Helper;
import me.tfeng.play.avro.d2.AvroD2Server;
import me.tfeng.play.plugins.AbstractPlugin;
import org.apache.avro.Protocol;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.factory.annotation.Value;
import play.Application;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Plugin
extends AbstractPlugin<AvroD2Plugin>
implements Watcher {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Plugin.class);
    private final Map<URI, AvroD2Client> clients = new HashMap<URI, AvroD2Client>();
    private Map<Class<?>, String> protocolPaths;
    @Value(value="${avro-d2-plugin.protocol-paths:avroProtocolPaths}")
    private String protocolPathsName;
    @Value(value="${avro-d2-plugin.server-host}")
    private String serverHost;
    @Value(value="${avro-d2-plugin.server-port}")
    private int serverPort;
    private List<AvroD2Server> servers;
    private ZooKeeper zk;
    @Value(value="${avro-d2-plugin.zk-connect-string}")
    private String zkConnectString;
    @Value(value="${avro-d2-plugin.zk-session-timeout:10000}")
    private int zkSessionTimeout;

    public static AvroD2Plugin getInstance() {
        return (AvroD2Plugin)((Object)Play.application().plugin(AvroD2Plugin.class));
    }

    public AvroD2Plugin(Application application) {
        super(application);
    }

    public <T> T getClient(Class<T> interfaceClass) {
        URI uri = AvroD2Helper.getUri(AvroHelper.getProtocol(interfaceClass));
        AvroD2Client client = this.clients.get(uri);
        if (client == null) {
            client = new AvroD2Client(this.zk, interfaceClass);
            this.clients.put(uri, client);
        }
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)client));
    }

    public void onStart() {
        super.onStart();
        this.protocolPaths = Collections.unmodifiableMap((Map)this.getApplicationContext().getBean(this.protocolPathsName, Map.class));
        try {
            this.zk = new ZooKeeper(this.zkConnectString, this.zkSessionTimeout, (Watcher)this);
            this.servers = new ArrayList<AvroD2Server>(this.protocolPaths.size());
            for (Map.Entry<Class<?>, String> entry : this.protocolPaths.entrySet()) {
                Protocol protocol = AvroHelper.getProtocol(entry.getKey());
                String path = entry.getValue();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                URL url = new URL("http", this.serverHost, this.serverPort, path);
                AvroD2Server server = new AvroD2Server(this.zk, protocol, url);
                this.servers.add(server);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize server", e);
        }
    }

    public void onStop() {
        this.stopServers();
    }

    public void process(WatchedEvent event) {
        LOG.info(event.toString());
    }

    public void refreshClients() {
        this.clients.clear();
    }

    public void stopServers() {
        this.servers.stream().forEach(server -> server.close());
        this.servers.clear();
    }
}

