/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.avro.d2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import me.tfeng.play.avro.d2.AvroD2Client;
import me.tfeng.play.avro.d2.AvroD2Helper;
import org.apache.avro.ipc.InternalHttpTransceiver;
import org.apache.avro.ipc.Transceiver;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AvroD2Transceiver
extends Transceiver {
    public static final String[] PRESERVED_HEADERS = new String[]{"Authorization"};
    private final AvroD2Client client;
    private final InternalHttpTransceiver transceiver;

    public AvroD2Transceiver(AvroD2Client client) {
        this.client = client;
        this.transceiver = new InternalHttpTransceiver(client.getNextServerUrl());
    }

    public String getRemoteName() throws IOException {
        return AvroD2Helper.getUri(this.client.getProtocol()).toString();
    }

    public List<ByteBuffer> readBuffers() throws IOException {
        return this.transceiver.readBuffers();
    }

    public void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        this.transceiver.writeBuffers(buffers, connection -> {
            Http.Request request = Controller.request();
            for (String preservedHeader : PRESERVED_HEADERS) {
                connection.setRequestProperty(preservedHeader, request.getHeader(preservedHeader));
            }
        });
    }
}

