/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.playmods.avro.d2;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.tfeng.playmods.avro.d2.AvroD2Server;
import me.tfeng.playmods.avro.d2.ZooKeeperProvider;
import me.tfeng.playmods.avro.d2.factories.ClientFactory;
import me.tfeng.toolbox.avro.AvroHelper;
import me.tfeng.toolbox.spring.ApplicationManager;
import me.tfeng.toolbox.spring.ExtendedStartable;
import org.apache.avro.Protocol;
import org.apache.avro.specific.SpecificData;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import play.Logger;

@Component(value="play-mods.avro-d2.component")
public class AvroD2Component
implements ExtendedStartable,
InitializingBean,
Watcher,
ZooKeeperProvider {
    public static final String PROTOCOL_PATHS_KEY = "play-mods.avro-d2.protocol-paths";
    private static final Logger.ALogger LOG = Logger.of(AvroD2Component.class);
    @Autowired
    @Qualifier(value="play-mods.spring.application-manager")
    private ApplicationManager applicationManager;
    @Autowired
    @Qualifier(value="play-mods.avro-d2.client-factory")
    private ClientFactory clientFactory;
    @Value(value="${play-mods.avro-d2.client-refresh-retry-delay:1000}")
    private long clientRefreshRetryDelay;
    @Value(value="${play-mods.avro-d2.enable-server:true}")
    private boolean enableServer;
    private boolean expired;
    private Map<Class<?>, String> protocolPaths;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Value(value="${play-mods.avro-d2.server-host:localhost}")
    private String serverHost;
    @Value(value="${play-mods.avro-d2.server-port:0}")
    private int serverPort;
    @Value(value="${play-mods.avro-d2.server-register-retry-delay:1000}")
    private long serverRegisterRetryDelay;
    private List<AvroD2Server> servers;
    private ZooKeeper zk;
    @Value(value="${play-mods.avro-d2.zk-connect-string:}")
    private String zkConnectString;
    @Value(value="${play-mods.avro-d2.zk-session-timeout:10000}")
    private int zkSessionTimeout;

    public void afterPropertiesSet() throws Exception {
        try {
            this.protocolPaths = (Map)this.applicationManager.getBean(PROTOCOL_PATHS_KEY, Map.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.protocolPaths = Collections.emptyMap();
        }
    }

    public void afterStart() {
        if (this.enableServer) {
            this.connect();
        }
    }

    public void afterStop() {
    }

    public void beforeStart() {
    }

    public void beforeStop() {
        if (this.enableServer) {
            this.stopServers();
        }
    }

    public <T> T client(Class<T> interfaceClass) {
        return this.client(interfaceClass, new SpecificData(interfaceClass.getClassLoader()));
    }

    public <T> T client(Class<T> interfaceClass, SpecificData data) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this.clientFactory.create(interfaceClass, data, false)));
    }

    public long getClientRefreshRetryDelay() {
        return this.clientRefreshRetryDelay;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public ZooKeeper getZooKeeper() {
        return this.zk;
    }

    public void onStart() throws Throwable {
    }

    public void onStop() throws Throwable {
    }

    public void process(WatchedEvent event) {
        LOG.info(event.toString());
        switch (event.getState()) {
            case SyncConnected: {
                if (!this.expired) break;
                this.expired = false;
                this.servers.forEach(AvroD2Server::register);
                break;
            }
            case Expired: {
                this.expired = true;
                try {
                    this.zk.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connect();
            }
        }
    }

    public void startServers() {
        this.servers = new ArrayList<AvroD2Server>(this.protocolPaths.size());
        for (Map.Entry<Class<?>, String> entry : this.protocolPaths.entrySet()) {
            URL url;
            Protocol protocol = AvroHelper.getProtocol(entry.getKey());
            String path = entry.getValue();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            try {
                url = new URL("http", this.serverHost, this.serverPort, path);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize server", e);
            }
            AvroD2Server server = new AvroD2Server(protocol, url, this.zk, this.scheduler, this.serverRegisterRetryDelay);
            server.register();
            this.servers.add(server);
        }
    }

    public void stopServers() {
        this.servers.stream().forEach(server -> {
            try {
                server.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close server for " + server.getProtocol().getName() + " at " + server.getUrl() + "; ignoring");
            }
        });
        this.servers.clear();
    }

    protected void connect() {
        try {
            this.zk = new ZooKeeper(this.zkConnectString, this.zkSessionTimeout, (Watcher)this);
            this.startServers();
        }
        catch (IOException e) {
            if (this.zk != null) {
                try {
                    this.zk.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.getScheduler().schedule(this::connect, this.clientRefreshRetryDelay, TimeUnit.MILLISECONDS);
            LOG.warn("Unable to connect to ZooKeeper; retry later", (Throwable)e);
        }
    }
}

