/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.playmods.avro.d2;

import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.tfeng.playmods.avro.d2.AvroD2Helper;
import org.apache.avro.Protocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import play.Logger;

public class AvroD2Server
implements Watcher {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Server.class);
    protected volatile String nodePath;
    private final Protocol protocol;
    private final ScheduledExecutorService scheduler;
    private final long serverRegisterRetryDelay;
    private final URL url;
    private final ZooKeeper zk;

    public AvroD2Server(Protocol protocol, URL url, ZooKeeper zk, ScheduledExecutorService scheduler, long serverRegisterRetryDelay) {
        this.protocol = protocol;
        this.url = url;
        this.zk = zk;
        this.scheduler = scheduler;
        this.serverRegisterRetryDelay = serverRegisterRetryDelay;
    }

    public synchronized void close() throws InterruptedException, KeeperException {
        String path = this.nodePath;
        if (path != null) {
            LOG.info("Closing server for " + this.protocol.getName() + " at " + this.url);
            try {
                this.zk.delete(path, -1);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            this.nodePath = null;
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URL getUrl() {
        return this.url;
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equals(this.nodePath) || event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.register();
        }
    }

    public synchronized void register() {
        try {
            this.close();
            if (this.zk == null) {
                this.scheduleRegister();
            }
            if (this.zk.getState() == ZooKeeper.States.CLOSED) {
                LOG.warn("ZooKeeper connection is closed; canceling registration for " + this.protocol.getName());
            } else {
                AvroD2Helper.createVersionNode(this.zk, this.protocol);
                this.nodePath = AvroD2Helper.createServerNode(this.zk, this.protocol, this.url);
                this.zk.getData(this.nodePath, (Watcher)this, null);
                LOG.info("Registered server for " + this.protocol.getName() + " at " + this.url);
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException) {
                LOG.warn("Unable to register server for " + this.protocol.getName() + " (code = " + ((KeeperException)((Object)e)).code() + "); retry later");
            } else {
                LOG.warn("Unable to register server for " + this.protocol.getName() + "; retry later", (Throwable)e);
            }
            this.scheduleRegister();
        }
    }

    private void scheduleRegister() {
        this.scheduler.schedule(this::register, this.serverRegisterRetryDelay, TimeUnit.MILLISECONDS);
    }
}

