/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.playmods.avro.d2;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import me.tfeng.playmods.avro.AvroConstants;
import me.tfeng.playmods.avro.ResponseProcessor;
import me.tfeng.playmods.avro.d2.AvroD2Component;
import me.tfeng.playmods.avro.d2.AvroD2Helper;
import me.tfeng.toolbox.avro.AvroHelper;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.ipc.AsyncRequestor;
import org.apache.avro.ipc.HandshakeMatch;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCContextHelper;
import org.apache.avro.util.ByteBufferInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="play-mods.avro-d2.response-processor")
public class AvroD2ResponseProcessor
implements ResponseProcessor {
    @Autowired
    @Qualifier(value="play-mods.avro-d2.component")
    private AvroD2Component avroD2Component;
    private final Map<String, Protocol> protocolCache = Collections.synchronizedMap(Maps.newHashMap());

    public Object process(AsyncRequestor requestor, AsyncRequestor.Request request, String message, List<ByteBuffer> response) throws Exception {
        Protocol serverProtocol;
        ByteBufferInputStream bbi = new ByteBufferInputStream(response);
        BinaryDecoder in = DecoderFactory.get().binaryDecoder((InputStream)bbi, null);
        HandshakeResponse handshake = (HandshakeResponse)AvroConstants.HANDSHAKE_RESPONSE_READER.read(null, (Decoder)in);
        Protocol localProtocol = requestor.getLocal();
        if (handshake.getMatch() == HandshakeMatch.BOTH) {
            serverProtocol = localProtocol;
        } else {
            String serverHash = DatatypeConverter.printHexBinary((byte[])handshake.getServerHash().bytes());
            serverProtocol = this.protocolCache.get(serverHash);
            if (serverProtocol == null) {
                serverProtocol = AvroD2Helper.readProtocolFromZk(this.avroD2Component.getZooKeeper(), localProtocol.getNamespace(), localProtocol.getName(), serverHash);
                this.protocolCache.put(serverHash, serverProtocol);
            }
        }
        RPCContext context = request.getContext();
        RPCContextHelper.setResponseCallMeta((RPCContext)context, (Map)((Map)AvroHelper.META_READER.read(null, (Decoder)in)));
        if (!in.readBoolean()) {
            Schema localSchema = ((Protocol.Message)localProtocol.getMessages().get(message)).getResponse();
            Schema remoteSchema = ((Protocol.Message)serverProtocol.getMessages().get(message)).getResponse();
            Object responseObject = requestor.getDatumReader(remoteSchema, localSchema).read(null, (Decoder)in);
            RPCContextHelper.setResponse((RPCContext)context, (Object)responseObject);
            requestor.getRPCPlugins().forEach(plugin -> plugin.clientReceiveResponse(context));
            return responseObject;
        }
        Schema localSchema = ((Protocol.Message)localProtocol.getMessages().get(message)).getErrors();
        Schema remoteSchema = ((Protocol.Message)serverProtocol.getMessages().get(message)).getErrors();
        Object error = requestor.getDatumReader(remoteSchema, localSchema).read(null, (Decoder)in);
        Exception exception = error instanceof Exception ? (Exception)error : new AvroRuntimeException(error.toString());
        RPCContextHelper.setError((RPCContext)context, (Exception)exception);
        requestor.getRPCPlugins().forEach(plugin -> plugin.clientReceiveResponse(context));
        throw exception;
    }
}

