/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.playmods.avro.d2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import me.tfeng.playmods.avro.AvroConstants;
import me.tfeng.playmods.avro.ProtocolVersionResolver;
import me.tfeng.playmods.avro.d2.AvroD2Component;
import me.tfeng.playmods.avro.d2.AvroD2Helper;
import org.apache.avro.Protocol;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.HandshakeMatch;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.zookeeper.KeeperException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import play.Logger;

@Component(value="play-mods.avro-d2.protocol-version-resolver")
public class AvroD2ProtocolVersionResolver
implements ProtocolVersionResolver {
    private static final Logger.ALogger LOG = Logger.of(AvroD2ProtocolVersionResolver.class);
    @Autowired
    @Qualifier(value="play-mods.avro-d2.component")
    private AvroD2Component avroD2Component;
    private Map<List<String>, Protocol> protocolCache = Maps.newHashMap();

    public Protocol resolve(Responder responder, Decoder in, Encoder out, Transceiver connection) throws IOException {
        Protocol serverProtocol = responder.getLocal();
        byte[] serverMD5 = serverProtocol.getMD5();
        String namespace = serverProtocol.getNamespace();
        String name = serverProtocol.getName();
        HandshakeRequest request = (HandshakeRequest)AvroConstants.HANDSHAKE_REQUEST_READER.read(null, in);
        MD5 clientHash = request.getClientHash();
        HandshakeResponse response = new HandshakeResponse();
        Protocol protocol = null;
        if (clientHash == null) {
            LOG.error("Client protocol MD5 is missing from request (namespace=" + namespace + ", name=" + name + ")");
        } else {
            byte[] clientMD5 = clientHash.bytes();
            if (Arrays.equals(clientMD5, serverMD5)) {
                protocol = serverProtocol;
                response.setMatch(HandshakeMatch.BOTH);
            } else {
                String clientMD5String = DatatypeConverter.printHexBinary((byte[])clientMD5);
                protocol = this.getProtocol(namespace, name, clientMD5String);
                if (protocol == null) {
                    try {
                        protocol = AvroD2Helper.readProtocolFromZk(this.avroD2Component.getZooKeeper(), namespace, name, clientMD5String);
                        response.setMatch(HandshakeMatch.CLIENT);
                        this.setProtocol(namespace, name, clientMD5String, protocol);
                    }
                    catch (InterruptedException | KeeperException e) {
                        LOG.error("Unable to read schema from ZooKeeper for protocol (namespace=" + namespace + ", name=" + name + ", MD5=" + clientMD5String + ")", e);
                    }
                } else {
                    response.setMatch(HandshakeMatch.CLIENT);
                }
            }
        }
        if (protocol == null) {
            response.setMatch(HandshakeMatch.NONE);
        }
        if (response.getMatch() != HandshakeMatch.BOTH) {
            response.setServerHash(new MD5(serverMD5));
        }
        RPCContext context = new RPCContext();
        context.setHandshakeRequest(request);
        context.setHandshakeResponse(response);
        AvroConstants.HANDSHAKE_RESPONSE_WRITER.write((Object)response, out);
        return protocol;
    }

    private synchronized Protocol getProtocol(String namespace, String name, String md5) {
        return this.protocolCache.get(ImmutableList.of((Object)namespace, (Object)name, (Object)md5));
    }

    private synchronized Protocol setProtocol(String namespace, String name, String md5, Protocol protocol) {
        return this.protocolCache.put((List<String>)ImmutableList.of((Object)namespace, (Object)name, (Object)md5), protocol);
    }
}

