/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.playmods.avro.d2;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import me.tfeng.toolbox.common.Constants;
import org.apache.avro.Protocol;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class AvroD2Helper {
    public static final String SCHEME = "avsd";

    public static String createServerNode(ZooKeeper zk, Protocol protocol, URL serverUrl) throws InterruptedException, KeeperException {
        AvroD2Helper.ensurePath(zk, AvroD2Helper.getServersZkPath(protocol));
        return zk.create(AvroD2Helper.getServersZkPath(protocol) + "/", serverUrl.toString().getBytes(), (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public static void createVersionNode(ZooKeeper zk, Protocol protocol) throws KeeperException, InterruptedException {
        String path = AvroD2Helper.getVersionsZkPath(protocol);
        String md5 = DatatypeConverter.printHexBinary((byte[])protocol.getMD5());
        AvroD2Helper.ensurePath(zk, path);
        try {
            zk.create(path + "/" + md5, protocol.toString().getBytes(Constants.UTF8), (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    public static void ensurePath(ZooKeeper zk, String path) throws InterruptedException, KeeperException {
        String part;
        int index = path.lastIndexOf("/");
        if (index > 0) {
            AvroD2Helper.ensurePath(zk, path.substring(0, index));
        }
        if (!(part = path.substring(index + 1)).isEmpty()) {
            try {
                zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    public static String getProtocolZkPath(String namespace, String name) {
        return "/protocols/" + (Strings.isNullOrEmpty((String)namespace) ? name : namespace + "." + name);
    }

    public static String getServersZkPath(Protocol protocol) {
        return AvroD2Helper.getProtocolZkPath(protocol.getNamespace(), protocol.getName()) + "/servers";
    }

    public static URI getUri(Protocol protocol) {
        try {
            return new URI("avsd:/" + AvroD2Helper.getVersionsZkPath(protocol));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getVersionsZkPath(Protocol protocol) {
        return AvroD2Helper.getProtocolZkPath(protocol.getNamespace(), protocol.getName()) + "/versions";
    }

    public static Protocol readProtocolFromZk(ZooKeeper zk, String namespace, String name, String md5) throws InterruptedException, KeeperException {
        String versionPath = AvroD2Helper.getProtocolZkPath(namespace, name) + "/versions/" + md5;
        byte[] data = zk.getData(versionPath, false, null);
        String schema = new String(data, Constants.UTF8);
        return Protocol.parse((String)schema);
    }
}

