/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.playmods.avro.d2;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.tfeng.playmods.avro.d2.AvroD2Helper;
import me.tfeng.playmods.avro.d2.ZooKeeperProvider;
import me.tfeng.playmods.avro.d2.factories.RequestorFactory;
import me.tfeng.playmods.avro.d2.factories.TransceiverFactory;
import me.tfeng.toolbox.common.Constants;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.AsyncRequestor;
import org.apache.avro.specific.SpecificData;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import play.Logger;
import play.libs.F;

public class AvroD2Client
implements Watcher,
InvocationHandler {
    private static final Logger.ALogger LOG = Logger.of(AvroD2Client.class);
    private final long clientRefreshRetryDelay;
    private final SpecificData data;
    private volatile boolean isVersionRegistered;
    private volatile int lastIndex = -1;
    private final Protocol protocol;
    private volatile boolean refreshed;
    private final RequestorFactory requestorFactory;
    private final ScheduledExecutorService scheduler;
    private final List<URL> serverUrls = Lists.newArrayList();
    private final TransceiverFactory transceiverFactory;
    private boolean useGenericRecord;
    private final ZooKeeperProvider zkProvider;

    public AvroD2Client(Protocol protocol, SpecificData data, RequestorFactory requestorFactory, TransceiverFactory transceiverFactory, ZooKeeperProvider zkProvider, ScheduledExecutorService scheduler, long clientRefreshRetryDelay, boolean useGenericRecord) {
        this.protocol = protocol;
        this.data = data;
        this.requestorFactory = requestorFactory;
        this.transceiverFactory = transceiverFactory;
        this.zkProvider = zkProvider;
        this.scheduler = scheduler;
        this.clientRefreshRetryDelay = clientRefreshRetryDelay;
        this.useGenericRecord = useGenericRecord;
    }

    public synchronized URL getNextServerUrl() {
        if (this.serverUrls.isEmpty()) {
            throw new RuntimeException("No server is found for " + this.protocol.getName());
        }
        this.lastIndex = (this.lastIndex + 1) % this.serverUrls.size();
        return this.serverUrls.get(this.lastIndex);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.setupRequest().invoke(proxy, method, args);
    }

    public void process(WatchedEvent event) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        List children;
        String path = AvroD2Helper.getServersZkPath(this.protocol);
        try {
            children = this.zkProvider.getZooKeeper().getChildren(path, (Watcher)this);
        }
        catch (Exception e) {
            LOG.warn("Unable to list servers for " + this.protocol.getName() + "; retry later", (Throwable)e);
            this.scheduleRefresh();
            return;
        }
        AvroD2Client avroD2Client = this;
        synchronized (avroD2Client) {
            this.serverUrls.clear();
            for (String child : children) {
                String childPath = path + "/" + child;
                try {
                    byte[] data = this.zkProvider.getZooKeeper().getData(childPath, false, null);
                    String serverUrl = new String(data, Constants.UTF8);
                    this.serverUrls.add(new URL(serverUrl));
                }
                catch (Exception e) {
                    LOG.warn("Unable to get server URL from node " + childPath, (Throwable)e);
                }
            }
            if (this.serverUrls.isEmpty()) {
                LOG.warn("Unable to get any server URL for protocol " + this.protocol.getName() + "; retry later");
                this.scheduleRefresh();
            }
        }
    }

    public F.Promise<Object> request(String message, Object[] request) throws Exception {
        return this.setupRequest().request(message, request);
    }

    private void scheduleRefresh() {
        this.scheduler.schedule(this::refresh, this.clientRefreshRetryDelay, TimeUnit.MILLISECONDS);
    }

    private synchronized AsyncRequestor setupRequest() throws IOException, InterruptedException, KeeperException {
        if (!this.refreshed) {
            this.refreshed = true;
            this.refresh();
        }
        if (!this.isVersionRegistered) {
            AvroD2Helper.createVersionNode(this.zkProvider.getZooKeeper(), this.protocol);
            this.isVersionRegistered = true;
        }
        return this.requestorFactory.create(this.protocol, this.transceiverFactory.create(this.protocol, this.getNextServerUrl()), this.data, this.useGenericRecord);
    }
}

