/*
 * Decompiled with CFR 0.152.
 */
package me.textflow;

import me.textflow.TextFlowVerifyPhoneData;
import org.json.JSONObject;

public class TextFlowVerifyPhoneResult {
    private Boolean ok;
    private Integer status;
    private String message;
    private TextFlowVerifyPhoneData data;

    TextFlowVerifyPhoneResult(Boolean ok, Integer status, String message, TextFlowVerifyPhoneData data) {
        this.ok = ok;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public TextFlowVerifyPhoneResult(String json) {
        JSONObject jsonObject = new JSONObject(json);
        try {
            this.ok = jsonObject.getBoolean("ok");
            this.status = jsonObject.getInt("status");
            this.message = jsonObject.getString("message");
            if (this.ok.booleanValue()) {
                JSONObject dataObject = jsonObject.getJSONObject("data");
                this.data = new TextFlowVerifyPhoneData(dataObject.getString("verification_code"), dataObject.getLong("expires"), dataObject.getString("message_text"));
            } else {
                this.data = new TextFlowVerifyPhoneData();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.ok = false;
            this.status = 500;
            this.message = "Server error. ";
            this.data = new TextFlowVerifyPhoneData();
        }
    }

    public Boolean isOk() {
        return this.ok;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public TextFlowVerifyPhoneData getData() {
        return this.data;
    }
}

