/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class MojoUtils {
    MojoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] checksum(File file) throws IOException {
        try {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            byte[] buffer = new byte[2048];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            try {
                int n;
                do {
                    if ((n = in.read(buffer)) <= 0) continue;
                    complete.update(buffer, 0, n);
                } while (n != -1);
            }
            finally {
                in.close();
            }
            return complete.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Could not create checksum " + file, ex);
        }
    }

    public static String findSourceSubdir(File sourceDirectory, File grammarFile) {
        String srcPath = sourceDirectory.getPath() + File.separator;
        String path = grammarFile.getPath();
        if (!path.startsWith(srcPath)) {
            throw new IllegalArgumentException("expected " + path + " to be prefixed with " + sourceDirectory);
        }
        File unprefixedGrammarFileName = new File(path.substring(srcPath.length()));
        if (unprefixedGrammarFileName.getParent() == null) {
            return "";
        }
        return unprefixedGrammarFileName.getParent() + File.separator;
    }
}

