/*
 * Decompiled with CFR 0.152.
 */
package me.sparky983.vision.paper;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import me.sparky983.vision.Button;
import me.sparky983.vision.Gui;
import me.sparky983.vision.GuiType;
import me.sparky983.vision.Slot;
import me.sparky983.vision.paper.GuiInventoryHolder;
import me.sparky983.vision.paper.PaperButtonMirror;
import me.sparky983.vision.paper.PaperInventoryMirror;
import me.sparky983.vision.paper.PaperItemTypeConverter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.Server;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class SubscribingPaperInventoryMirror
implements PaperInventoryMirror {
    private static final String UNABLE_TO_MIRROR_MESSAGE = "Unable to converter item type \"%s\". Possible causes:\n- The item is not available in this version of Minecraft\n- Legacy materials are enabled\n";
    private final Server server;
    private final PaperItemTypeConverter itemTypeConverter;
    private final PaperButtonMirror buttonMirror;

    SubscribingPaperInventoryMirror(Server server, PaperItemTypeConverter itemTypeConverter, PaperButtonMirror buttonMirror) {
        Objects.requireNonNull(server, "server cannot be null");
        Objects.requireNonNull(itemTypeConverter, "itemTypeConverter cannot be null");
        Objects.requireNonNull(buttonMirror, "buttonMirror cannot be null");
        this.server = server;
        this.itemTypeConverter = itemTypeConverter;
        this.buttonMirror = buttonMirror;
    }

    @Override
    public Inventory mirror(final Gui gui, final Locale locale) {
        Objects.requireNonNull(gui, "gui cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        Component title = GlobalTranslator.render((Component)gui.title(), (Locale)locale);
        Function<InventoryHolder, Inventory> inventoryFactory = inventoryHolder -> switch (gui.type()) {
            default -> throw new IncompatibleClassChangeError();
            case GuiType.CHEST -> this.server.createInventory(inventoryHolder, gui.rows() * gui.columns(), title);
            case GuiType.HOPPER -> this.server.createInventory(inventoryHolder, InventoryType.HOPPER, title);
            case GuiType.DROPPER -> this.server.createInventory(inventoryHolder, InventoryType.DROPPER, title);
        };
        final Inventory inventory = new GuiInventoryHolder(gui, inventoryFactory).getInventory();
        Gui.Subscriber subscriber = new Gui.Subscriber(){

            public void button(Slot slot, @Nullable Button button) {
                if (button == null) {
                    return;
                }
                ItemStack item = SubscribingPaperInventoryMirror.this.itemTypeConverter.convert(button.type()).map(ItemStack::new).orElseThrow(() -> new IllegalStateException(String.format(SubscribingPaperInventoryMirror.UNABLE_TO_MIRROR_MESSAGE, button.type())));
                int rawSlot = slot.column() + slot.row() * gui.columns();
                inventory.setItem(rawSlot, item);
                ItemStack craftItem = inventory.getItem(rawSlot);
                assert (craftItem != null);
                SubscribingPaperInventoryMirror.this.buttonMirror.mirror(button, craftItem, locale);
            }
        };
        for (Slot slot : gui.slots()) {
            gui.button(slot).ifPresent(button -> subscriber.button(slot, button));
        }
        gui.subscribe(subscriber);
        return inventory;
    }
}

