/*
 * Decompiled with CFR 0.152.
 */
package me.sparky983.vision.paper;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.sparky983.vision.Button;
import me.sparky983.vision.ItemType;
import me.sparky983.vision.paper.PaperButtonMirror;
import me.sparky983.vision.paper.PaperComponentFixer;
import me.sparky983.vision.paper.PaperItemTypeConverter;
import net.kyori.adventure.text.Component;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class SubscribingPaperButtonMirror
implements PaperButtonMirror {
    private final PaperComponentFixer componentFixer;
    private final PaperItemTypeConverter itemTypeConverter;

    SubscribingPaperButtonMirror(PaperComponentFixer componentFixer, PaperItemTypeConverter itemTypeConverter) {
        Objects.requireNonNull(componentFixer, "componentFixer cannot be null");
        Objects.requireNonNull(itemTypeConverter, "itemTypeConverter cannot be null");
        this.componentFixer = componentFixer;
        this.itemTypeConverter = itemTypeConverter;
    }

    @Override
    public void mirror(Button button, final ItemStack item, final Locale locale) {
        Objects.requireNonNull(button, "button cannot be null");
        Objects.requireNonNull(item, "item cannot be null");
        Objects.requireNonNull(locale, "locale cannot be null");
        item.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        Button.Subscriber subscriber = new Button.Subscriber(){

            public void type(ItemType type) {
                SubscribingPaperButtonMirror.this.itemTypeConverter.convert(type).ifPresent(arg_0 -> ((ItemStack)item).setType(arg_0));
            }

            public void name(Component name) {
                item.editMeta(meta -> meta.displayName(SubscribingPaperButtonMirror.this.componentFixer.convert(name, locale)));
            }

            public void lore(List<Component> lore) {
                item.editMeta(meta -> meta.lore(lore.stream().map(line -> SubscribingPaperButtonMirror.this.componentFixer.convert((Component)line, locale)).toList()));
            }

            public void amount(int amount) {
                item.setAmount(amount);
            }

            public void glow(boolean glow) {
                if (glow) {
                    item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                } else {
                    item.removeEnchantment(Enchantment.DURABILITY);
                }
            }
        };
        subscriber.type(button.type());
        subscriber.name(button.name());
        subscriber.lore(button.lore());
        subscriber.amount(button.amount());
        subscriber.glow(button.glow());
        button.subscribe(subscriber);
    }
}

