/*
 * Decompiled with CFR 0.152.
 */
package me.sparky983.vision.paper;

import java.util.Objects;
import me.sparky983.vision.Gui;
import me.sparky983.vision.paper.InventoryListener;
import me.sparky983.vision.paper.PaperInventoryMirror;
import me.sparky983.vision.paper.PaperVision;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class PaperVisionImpl
implements PaperVision {
    private final Plugin plugin;
    private final PluginManager pluginManager;
    private final PaperInventoryMirror inventoryMirror;
    private @Nullable InventoryListener inventoryListener;

    PaperVisionImpl(Plugin plugin, PluginManager pluginManager, PaperInventoryMirror inventoryMirror) {
        Objects.requireNonNull(plugin, "plugin cannot be null");
        Objects.requireNonNull(pluginManager, "pluginManager cannot be null");
        Objects.requireNonNull(inventoryMirror, "inventoryMirror cannot be null");
        this.plugin = plugin;
        this.pluginManager = pluginManager;
        this.inventoryMirror = inventoryMirror;
    }

    @Override
    public void open(Player player, Gui gui) {
        Objects.requireNonNull(player, "player cannot be null");
        Objects.requireNonNull(gui, "gui cannot be null");
        if (this.inventoryListener == null) {
            this.inventoryListener = new InventoryListener(this);
            this.pluginManager.registerEvents((Listener)this.inventoryListener, this.plugin);
        }
        Inventory inventory = this.inventoryMirror.mirror(gui, player.locale());
        player.openInventory(inventory);
    }
}

