/*
 * Decompiled with CFR 0.152.
 */
package me.sparky983.vision.paper;

import java.util.Objects;
import me.sparky983.vision.Button;
import me.sparky983.vision.Click;
import me.sparky983.vision.ClickType;
import me.sparky983.vision.Gui;
import me.sparky983.vision.Slot;
import me.sparky983.vision.paper.GuiInventoryHolder;
import me.sparky983.vision.paper.PaperClick;
import me.sparky983.vision.paper.PaperVision;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class InventoryListener
implements Listener {
    private final PaperVision vision;

    InventoryListener(PaperVision vision) {
        Objects.requireNonNull(vision, "vision cannot be null");
        this.vision = vision;
    }

    @EventHandler
    void onInventoryClick(InventoryClickEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof GuiInventoryHolder)) {
            return;
        }
        GuiInventoryHolder guiInventoryHolder = (GuiInventoryHolder)inventoryHolder;
        event.setCancelled(true);
        if (!Objects.equals(event.getInventory(), event.getClickedInventory())) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Gui gui = guiInventoryHolder.gui();
        Slot slot = (Slot)gui.slots().get(event.getSlot());
        gui.button(slot).ifPresent(button -> {
            ClickType type;
            switch (event.getClick()) {
                case LEFT: {
                    ClickType clickType = ClickType.LEFT;
                    break;
                }
                case SHIFT_LEFT: {
                    ClickType clickType = ClickType.SHIFT_LEFT;
                    break;
                }
                case RIGHT: {
                    ClickType clickType = ClickType.RIGHT;
                    break;
                }
                case SHIFT_RIGHT: {
                    ClickType clickType = ClickType.SHIFT_RIGHT;
                    break;
                }
                case MIDDLE: {
                    ClickType clickType = ClickType.MIDDLE;
                    break;
                }
                case DROP: {
                    ClickType clickType = ClickType.DROP;
                    break;
                }
                case CONTROL_DROP: {
                    ClickType clickType = ClickType.CONTROL_DROP;
                    break;
                }
                case DOUBLE_CLICK: {
                    ClickType clickType = ClickType.DOUBLE_CLICK;
                    break;
                }
                case NUMBER_KEY: {
                    ClickType clickType = ClickType.NUMBER_KEY;
                    break;
                }
                default: {
                    ClickType clickType = type = null;
                }
            }
            if (type == null) {
                return;
            }
            button.click((Click)new PaperClick(player, (Button)button, slot, type, this.vision));
        });
    }
}

