package org.mentawai.db;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

import org.hibernate.Session;

public class SessionConnection implements Connection {
	
	private static Method method = null;
	
	private final Session session;
	private final Connection conn;
	
	public SessionConnection(Session session) {
		this.session = session;
		this.conn = getConnectionFrom(session);
	}
	
	private Connection getConnectionFrom(Session session) {
		if (method == null) {
			try {
				method = session.getClass().getMethod("getConnection");
			} catch(Exception e) {
				throw new org.mentawai.util.RuntimeException("Cannot find getConnection method!");
			}
		}
		
		try {
			return (Connection) method.invoke(session, (Object[]) null);
		} catch(Exception e) {
			throw new org.mentawai.util.RuntimeException("Error getting connection from session!");
		}
	}
	
	public Session getSession() {
		return session;
	}

	public <T> T unwrap(Class<T> iface) throws SQLException {
	    return conn.unwrap(iface);
    }

	public boolean isWrapperFor(Class<?> iface) throws SQLException {
	    return conn.isWrapperFor(iface);
    }

	public Statement createStatement() throws SQLException {
	    return conn.createStatement();
    }

	public PreparedStatement prepareStatement(String sql) throws SQLException {
	    return conn.prepareStatement(sql);
    }

	public CallableStatement prepareCall(String sql) throws SQLException {
	    return conn.prepareCall(sql);
    }

	public String nativeSQL(String sql) throws SQLException {
	    return conn.nativeSQL(sql);
    }

	public void setAutoCommit(boolean autoCommit) throws SQLException {
	    conn.setAutoCommit(autoCommit);
    }

	public boolean getAutoCommit() throws SQLException {
	    return conn.getAutoCommit();
    }

	public void commit() throws SQLException {
	    conn.commit();
    }

	public void rollback() throws SQLException {
	    conn.rollback();
    }

	// close the SESSION instead of the CONNECTION here...
	public void close() throws SQLException {
	    session.close();
    }

	public boolean isClosed() throws SQLException {
	    return conn.isClosed();
    }

	public DatabaseMetaData getMetaData() throws SQLException {
	    return conn.getMetaData();
    }

	public void setReadOnly(boolean readOnly) throws SQLException {
	    conn.setReadOnly(readOnly);
    }

	public boolean isReadOnly() throws SQLException {
	    return conn.isReadOnly();
    }

	public void setCatalog(String catalog) throws SQLException {
	    conn.setCatalog(catalog);
    }

	public String getCatalog() throws SQLException {
	    return conn.getCatalog();
    }

	public void setTransactionIsolation(int level) throws SQLException {
	    conn.setTransactionIsolation(level);
    }

	public int getTransactionIsolation() throws SQLException {
	    return conn.getTransactionIsolation();
    }

	public SQLWarning getWarnings() throws SQLException {
	    return conn.getWarnings();
    }

	public void clearWarnings() throws SQLException {
	    conn.clearWarnings();
    }

	public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
	    return conn.createStatement(resultSetType, resultSetConcurrency);
    }

	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
	    return conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
	    return conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

	public Map<String, Class<?>> getTypeMap() throws SQLException {
	    return conn.getTypeMap();
    }

	public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
	    conn.setTypeMap(map);
    }

	public void setHoldability(int holdability) throws SQLException {
	    conn.setHoldability(holdability);
    }

	public int getHoldability() throws SQLException {
	    return conn.getHoldability();
    }

	public Savepoint setSavepoint() throws SQLException {
	    return conn.setSavepoint();
    }

	public Savepoint setSavepoint(String name) throws SQLException {
	    return conn.setSavepoint(name);
    }

	public void rollback(Savepoint savepoint) throws SQLException {
	    conn.rollback(savepoint);
    }

	public void releaseSavepoint(Savepoint savepoint) throws SQLException {
	    conn.releaseSavepoint(savepoint);
    }

	public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
	    return conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
	    return conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
	    return conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

	public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
	    return conn.prepareStatement(sql, autoGeneratedKeys);
    }

	public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
	    return conn.prepareStatement(sql, columnIndexes);
    }

	public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
	    return conn.prepareStatement(sql, columnNames);
    }

	public Clob createClob() throws SQLException {
	    return conn.createClob();
    }

	public Blob createBlob() throws SQLException {
	    return conn.createBlob();
    }

	public NClob createNClob() throws SQLException {
	    return conn.createNClob();
    }

	public SQLXML createSQLXML() throws SQLException {
	    return conn.createSQLXML();
    }

	public boolean isValid(int timeout) throws SQLException {
	    return conn.isValid(timeout);
    }

	public void setClientInfo(String name, String value) throws SQLClientInfoException {
	    conn.setClientInfo(name, value);
    }

	public void setClientInfo(Properties properties) throws SQLClientInfoException {
	    conn.setClientInfo(properties);
    }

	public String getClientInfo(String name) throws SQLException {
	    return conn.getClientInfo(name);
    }

	public Properties getClientInfo() throws SQLException {
	    return conn.getClientInfo();
    }

	public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
	    return conn.createArrayOf(typeName, elements);
    }

	public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
	    return conn.createStruct(typeName, attributes);
    }
}