/*
 * Mentawai Web Framework http://mentawai.lohis.com.br/
 * Copyright (C) 2005  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentawai.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Defines a Mentawai consequence.
 * In Mentawai, an action has a result that in turn has a consequence.
 * 
 * @author Sergio Oliveira
 */
public interface Consequence {
	
    /**
     * Executes this consequence.
     * A consequence must do something with your web application.
     * Here is where you define what the consequence does.
     *
     * @param a The action that generated this consequence.
     * @param result The result generated by the action.
     * @param req The servlet request of the action.
     * @param res The servlet response of the action.
     */
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException;
	
}
